/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.application.handler;

import com.castsoftware.sca.scar.server.application.configuration.MutableProperties;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ConfigurationWriter {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ConfigurationWriter.class);
    private final ObjectMapper serializer;
    private final Yaml yaml;

    public ConfigurationWriter(ObjectMapper serializer, Yaml yaml) {
        this.serializer = serializer;
        this.yaml = yaml;
    }

    public void write(MutableProperties desktopConfiguration, Path toWrite, Path toBackup) {
        block17: {
            Path path = (Path)Guards.notNull((Object)toWrite, (Supplier)Suppliers.illegalArgument((String)"Path file is mandatory"));
            Path backup = (Path)Guards.notNull((Object)toBackup, (Supplier)Suppliers.illegalArgument((String)"Backup path is mandatory"));
            try {
                Files.deleteIfExists(backup);
            }
            catch (Throwable e) {
                throw Exceptions.wrap((Throwable)e);
            }
            try {
                Optional<Map> dataToDump;
                if (Files.exists(path, new LinkOption[0])) {
                    Files.copy(path, backup, StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(path);
                }
                if (!(dataToDump = Optional.ofNullable(desktopConfiguration).map(c -> (Map)this.serializer.convertValue(c, Map.class)).map(map -> map.entrySet()).map(entries -> entries.stream().filter(entry -> Optional.ofNullable(entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).isPresent()) break block17;
                try (FileWriter writer = new FileWriter(path.toFile());){
                    this.yaml.dump((Object)dataToDump.get(), (Writer)writer);
                }
            }
            catch (Throwable exception) {
                this.rollback(toWrite, toBackup);
                LOGGER.error("fail to write configuration", exception);
                throw Exceptions.wrap((Throwable)exception);
            }
            finally {
                try {
                    Files.deleteIfExists(backup);
                }
                catch (IOException e) {
                    throw Exceptions.wrap((Throwable)e);
                }
            }
        }
    }

    private void rollback(Path toWrite, Path toBackup) {
        try {
            if (Files.exists(toBackup, new LinkOption[0])) {
                Files.copy(toBackup, toWrite, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Throwable t) {
            LOGGER.error("fail to rollback configuration");
            Optional.of(LOGGER).filter(Logger::isDebugEnabled).ifPresent(l -> l.debug("", t));
            throw Exceptions.wrap((Throwable)t);
        }
    }
}

