/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.service;

import com.castsoftware.sca.scar.server.sam.exception.CannotConnectToSamException;
import com.castsoftware.sca.scar.server.sam.requester.SamAuthenticationRequester;
import com.castsoftware.sca.scar.server.security.model.request.LoginRequest;
import com.castsoftware.sca.scar.server.security.service.AuthService;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClientResponseException;

@RestController
@RequestMapping(value={"/resources/auth"}, produces={"application/json"})
public class Authentication {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(Authentication.class);
    private static final String ACCESS_TOKEN = "JSESSIONID";
    private static final String XSRF_TOKEN = "XSRF-TOKEN";
    private final SamAuthenticationRequester samAuthenticationRequester;
    private final AuthService authService;
    private final CsrfTokenRepository csrfTokenRepository;

    @PostMapping(value={"/login"}, consumes={"application/json"})
    public ResponseEntity<Void> login(@Valid @RequestBody LoginRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.authService.login(request, servletRequest, servletResponse);
        CsrfToken csrfToken = this.csrfTokenRepository.generateToken(servletRequest);
        this.csrfTokenRepository.saveToken(csrfToken, servletRequest, servletResponse);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<Void> logout(HttpServletRequest request, HttpServletResponse response) {
        this.authService.logout(request, response);
        Cookie sessionCookie = new Cookie(ACCESS_TOKEN, null);
        String cookiePath = request.getContextPath() + "/";
        sessionCookie.setPath(cookiePath);
        sessionCookie.setMaxAge(0);
        sessionCookie.setSecure(request.isSecure());
        response.addCookie(sessionCookie);
        Cookie csrfCookie = new Cookie(XSRF_TOKEN, null);
        csrfCookie.setPath(cookiePath);
        csrfCookie.setMaxAge(0);
        csrfCookie.setSecure(request.isSecure());
        response.addCookie(csrfCookie);
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/reset"}, consumes={"application/json"})
    public ResponseEntity<Void> resetOwner(@Valid @RequestBody LoginRequest req) {
        String email = req.getEmail();
        String password = req.getPassword();
        this.samAuthenticationRequester.signInWithPassword(email, password).doOnError(WebClientResponseException.Unauthorized.class::isInstance, t -> {
            throw new RuntimeException((Throwable)t);
        }).doOnError(WebClientResponseException.class::isInstance, t -> {
            throw new CannotConnectToSamException(t);
        }).blockOptional().orElseThrow(() -> new CannotConnectToSamException(null));
        this.authService.resetOwner(email, password);
        return ResponseEntity.accepted().build();
    }

    @Generated
    public Authentication(SamAuthenticationRequester samAuthenticationRequester, AuthService authService, CsrfTokenRepository csrfTokenRepository) {
        this.samAuthenticationRequester = samAuthenticationRequester;
        this.authService = authService;
        this.csrfTokenRepository = csrfTokenRepository;
    }
}

