/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.vulnerability.dto.CreateVulnerabilityRequest;
import com.castsoftware.sca.scar.server.vulnerability.dto.DetailedVulnerabilityView;
import com.castsoftware.sca.scar.server.vulnerability.dto.UpdateVulnerabilityRequest;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import com.castsoftware.sca.scar.server.vulnerability.service.VulnerabilityService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.net.URI;
import java.util.Collection;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/vulnerabilities"}, produces={"application/json"})
public class VulnerabilityResource {
    private final VulnerabilityService vulnerabilityService;

    @PreAuthorize(value="hasRole('VULNERABILITY_READ')")
    @GetMapping
    public Collection<? extends VulnerabilityView> getVulnerabilities(@RequestParam(defaultValue="false") boolean withDetails) {
        return withDetails ? this.vulnerabilityService.getVulnerabilitiesWithDetails() : this.vulnerabilityService.getVulnerabilities();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_READ')")
    @GetMapping(value={"/{vulnerabilityId}"})
    public VulnerabilityView getVulnerability(@PathVariable @NotBlank String vulnerabilityId) {
        return this.vulnerabilityService.getVulnerability(vulnerabilityId);
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<DetailedVulnerabilityView> createVulnerability(@Valid @RequestBody CreateVulnerabilityRequest request) {
        String id = this.vulnerabilityService.createVulnerability(request);
        return ResponseEntity.created((URI)this.getVulnerabilityUri(id)).build();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @PutMapping(value={"/{vulnerabilityId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateVulnerability(@PathVariable @NotBlank String vulnerabilityId, @Valid @RequestBody UpdateVulnerabilityRequest request) {
        this.vulnerabilityService.editVulnerability(vulnerabilityId, request);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getVulnerabilityUri(vulnerabilityId))).build();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @DeleteMapping(value={"/{vulnerabilityId}"})
    public ResponseEntity<Void> deleteVulnerability(@PathVariable @NotBlank String vulnerabilityId) {
        this.vulnerabilityService.deleteVulnerability(vulnerabilityId);
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @DeleteMapping(value={"/unlinked"})
    public ResponseEntity<Void> deleteUnlinkedVulnerabilities() {
        this.vulnerabilityService.deleteUnlinkedVulnerabilities();
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_READ')")
    @GetMapping(value={"/types"})
    public Collection<String> getTypes() {
        return this.vulnerabilityService.getVulnerabilityTypes();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_READ')")
    @GetMapping(value={"/severities"})
    public Collection<String> getSeverities() {
        return this.vulnerabilityService.getVulnerabilitySeverities();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @GetMapping(value={"/external/{name}"})
    public DetailedVulnerabilityView getExternalVulnerability(@PathVariable @NotBlank(message="Vulnerability name cannot be blank") @Pattern(regexp="^(?i)CVE-.*", message="Vulnerability name must start with 'CVE-'") @NotBlank(message="Vulnerability name cannot be blank") @Pattern(regexp="^(?i)CVE-.*", message="Vulnerability name must start with 'CVE-'") String name) {
        return this.vulnerabilityService.searchExternalForAutofill(name);
    }

    private @NonNull URI getVulnerabilityUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((VulnerabilityResource)MvcUriComponentsBuilder.on(this.getClass())).getVulnerability(id)).build().getPath());
    }

    @Generated
    public VulnerabilityResource(VulnerabilityService vulnerabilityService) {
        this.vulnerabilityService = vulnerabilityService;
    }
}

