/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.user.model.DetailedUserRoleView;
import com.castsoftware.sca.scar.server.user.model.UserRoleView;
import com.castsoftware.sca.scar.server.user.model.request.CreateUserRoleRequest;
import com.castsoftware.sca.scar.server.user.model.request.EditUserRoleRequest;
import com.castsoftware.sca.scar.server.user.service.UserService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.Collection;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/user-roles"}, produces={"application/json"})
public class UserRolesResource {
    private final UserService userService;

    @PreAuthorize(value="hasRole('USER_READ')")
    @GetMapping
    public Collection<DetailedUserRoleView> getUserRoles() {
        return this.userService.getDetailedUserRoles();
    }

    @PreAuthorize(value="hasRole('USER_READ')")
    @GetMapping(value={"/{userRoleId}"})
    public UserRoleView getUserRole(@PathVariable @NotBlank String userRoleId) {
        return this.userService.getUserRole(userRoleId);
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Void> createUserRole(@Valid @RequestBody CreateUserRoleRequest request) {
        String id = this.userService.createUserRole(request);
        return ResponseEntity.created((URI)this.getUserRoleUri(id)).build();
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PutMapping(value={"/{userRoleId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateUserRole(@PathVariable @NotBlank String userRoleId, @Valid @RequestBody EditUserRoleRequest request) {
        this.userService.editUserRole(userRoleId, request);
        return ResponseEntity.accepted().build();
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @DeleteMapping(value={"/{userRoleId}"})
    public ResponseEntity<Void> deleteUserRole(@PathVariable @NotBlank String userRoleId) {
        this.userService.deleteUserRole(userRoleId);
        return ResponseEntity.accepted().build();
    }

    private @NonNull URI getUserRoleUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((UserRolesResource)MvcUriComponentsBuilder.on(this.getClass())).getUserRole(id)).build().getPath());
    }

    @Generated
    public UserRolesResource(UserService userService) {
        this.userService = userService;
    }
}

