/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.api.util.SecurityUtils;
import com.castsoftware.sca.scar.server.user.model.FullUserView;
import com.castsoftware.sca.scar.server.user.model.request.ChangeUserPasswordRequest;
import com.castsoftware.sca.scar.server.user.model.request.CreateUserRequest;
import com.castsoftware.sca.scar.server.user.model.request.EditUserRequest;
import com.castsoftware.sca.scar.server.user.service.UserService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.Collection;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/users"}, produces={"application/json"})
public class UserResource {
    private final UserService userService;

    @PreAuthorize(value="hasRole('USER_READ')")
    @GetMapping
    public Collection<FullUserView> getUsers() {
        return this.userService.getUsers();
    }

    @PreAuthorize(value="hasRole('USER_READ')")
    @GetMapping(value={"/{userId}"})
    public FullUserView getUser(@PathVariable @NotBlank String userId) {
        return this.userService.getUser(userId);
    }

    @GetMapping(value={"/whoami"})
    public FullUserView getCurrentUser() {
        return SecurityUtils.getLoggedInUser();
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Void> createUser(@Valid @RequestBody CreateUserRequest request) {
        String id = this.userService.createUser(request);
        return ResponseEntity.created((URI)this.getUserUri(id)).build();
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PutMapping(value={"/{userId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateUser(@PathVariable @NotBlank String userId, @Valid @RequestBody EditUserRequest request) {
        this.userService.editUser(userId, request);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getUserUri(userId))).build();
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @DeleteMapping(value={"/{userId}"})
    public ResponseEntity<Void> deleteUser(@PathVariable @NotBlank String userId) {
        this.userService.deleteUser(userId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{userId}/reset-password"}, consumes={"application/json"})
    public ResponseEntity<Void> changeUserPassword(@PathVariable @NotBlank String userId, @Valid @RequestBody ChangeUserPasswordRequest request) {
        this.userService.changePassword(userId, request);
        return ResponseEntity.accepted().build();
    }

    private @NonNull URI getUserUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((UserResource)MvcUriComponentsBuilder.on(this.getClass())).getUser(id)).build().getPath());
    }

    @Generated
    public UserResource(UserService userService) {
        this.userService = userService;
    }
}

