/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.bom.model.ProjectView;
import com.castsoftware.sca.scar.server.bom.model.VersionView;
import com.castsoftware.sca.scar.server.bom.model.request.BomBuildRequest;
import com.castsoftware.sca.scar.server.bom.service.BomService;
import com.castsoftware.sca.scar.server.bom.service.ProductService;
import com.castsoftware.sca.scar.server.kpi.model.KPIsView;
import jakarta.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/projects"}, produces={"application/json"})
public class ProjectResource {
    private final ProductService productService;
    private final BomService bomService;

    @GetMapping(value={"/{projectId}"})
    public ProjectView getProject(@PathVariable @NotBlank String projectId) {
        return this.productService.getProject(projectId);
    }

    @GetMapping(value={"/{projectId}/bomBuildConfiguration/last"})
    public BomBuildRequest getLastBomBuildConfiguration(@PathVariable @NotBlank String projectId) {
        return this.productService.getProjectLastBomBuildConfiguration(projectId);
    }

    @GetMapping(value={"/{projectId}/versions"})
    public List<VersionView> getVersions(@PathVariable @NotBlank String projectId) {
        return this.productService.getProjectVersions(projectId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{projectId}/boms/kpis"})
    public Collection<KPIsView> getBomKpis(@PathVariable @NotBlank String projectId) {
        return this.bomService.getKpisFromProject(projectId);
    }

    @Generated
    public ProjectResource(ProductService productService, BomService bomService) {
        this.productService = productService;
        this.bomService = bomService;
    }
}

