/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.bom.model.NameFilter;
import com.castsoftware.sca.scar.server.bom.model.ProductView;
import com.castsoftware.sca.scar.server.bom.model.ProjectView;
import com.castsoftware.sca.scar.server.bom.model.VersionView;
import com.castsoftware.sca.scar.server.bom.service.ProductService;
import com.castsoftware.sca.util.java.Opt;
import jakarta.validation.constraints.NotBlank;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/products"}, produces={"application/json"})
public class ProductResource {
    private final ProductService productService;

    @GetMapping
    public Collection<ProductView> getProducts(@RequestParam(defaultValue="") String n) {
        return this.productService.getProducts(this.prepareNameFilter(n));
    }

    @GetMapping(value={"/{productId}"})
    public ProductView getProduct(@PathVariable @NotBlank String productId) {
        return this.productService.getProduct(productId);
    }

    @GetMapping(value={"/{productId}/projects"})
    public Collection<ProjectView> getProjects(@PathVariable @NotBlank String productId, @RequestParam(defaultValue="") String n) {
        return this.productService.getProjects(productId, this.prepareNameFilter(n));
    }

    @GetMapping(value={"/{productId}/projects/{projectId}"})
    public ProjectView getProject(@PathVariable @NotBlank String productId, @PathVariable @NotBlank String projectId) {
        return this.productService.getProject(productId, projectId);
    }

    @GetMapping(value={"/{productId}/projects/{projectId}/versions"})
    public List<VersionView> getVersions(@PathVariable @NotBlank String productId, @PathVariable @NotBlank String projectId) {
        return this.productService.getProjectVersions(projectId);
    }

    private @NonNull NameFilter prepareNameFilter(String name) {
        NameFilter filter = new NameFilter();
        Opt.ofBlankString((String)name).ifPresent(arg_0 -> ((NameFilter)filter).setName(arg_0));
        filter.setStrict(false);
        return filter;
    }

    @Generated
    public ProductResource(ProductService productService) {
        this.productService = productService;
    }
}

