/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.preference.domain.BomPreferences;
import com.castsoftware.sca.scar.server.preference.domain.ReviewStep;
import com.castsoftware.sca.scar.server.preference.domain.ScannerPreferences;
import com.castsoftware.sca.scar.server.preference.domain.TablePreferences;
import com.castsoftware.sca.scar.server.preference.model.request.BomPreferencesRequest;
import com.castsoftware.sca.scar.server.preference.model.request.ScannerPreferencesRequest;
import com.castsoftware.sca.scar.server.preference.model.request.TablePreferencesRequest;
import com.castsoftware.sca.scar.server.preference.service.PreferencesService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/preferences"}, produces={"application/json"})
public class PreferenceResource {
    private final PreferencesService preferencesService;

    @GetMapping(value={"/table/{tableName}"})
    public TablePreferences getTablePreferences(@PathVariable @NotBlank String tableName) {
        return this.preferencesService.getTablePreferences(tableName);
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PutMapping(value={"/table/{tableName}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateTablePreferences(@PathVariable @NotBlank String tableName, @Valid @RequestBody TablePreferencesRequest request) {
        this.preferencesService.updateTablePreferences(tableName, request);
        return ResponseEntity.accepted().build();
    }

    @GetMapping(value={"/bom/{bomType}"})
    public BomPreferences getBomPreferences(@PathVariable @NotBlank String bomType) {
        return this.preferencesService.getBomPreferences(bomType);
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PutMapping(value={"/bom/{bomType}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateBomPreferences(@PathVariable @NotBlank String bomType, @Valid @RequestBody BomPreferencesRequest request) {
        this.preferencesService.updateBomPreferences(bomType, request);
        return ResponseEntity.accepted().build();
    }

    @GetMapping(value={"/scanner"})
    public ScannerPreferences getScannerPreferences() {
        return this.preferencesService.getScannerPreferences();
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PutMapping(value={"/scanner"}, consumes={"application/json"})
    public ResponseEntity<Void> updateScannerPreferences(@Valid @RequestBody ScannerPreferencesRequest request) {
        this.preferencesService.updateScannerPreferences(request);
        return ResponseEntity.accepted().build();
    }

    @GetMapping(value={"/review/steps"})
    public List<ReviewStep> getReviewSteps() {
        return this.preferencesService.getReviewSteps();
    }

    @Generated
    public PreferenceResource(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }
}

