/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.api.model.request.operation.ComponentMergeRequest;
import com.castsoftware.sca.scar.server.api.model.request.operation.ComponentSplitRequest;
import com.castsoftware.sca.scar.server.api.model.request.operation.CreateFileComponentRequest;
import com.castsoftware.sca.scar.server.api.model.request.operation.MoveFileComponentRequest;
import com.castsoftware.sca.scar.server.api.model.request.operation.OperationRequest;
import com.castsoftware.sca.scar.server.api.model.request.operation.OperationRequestVisitor;
import com.castsoftware.sca.scar.server.api.resource.OperationResource;
import com.castsoftware.sca.scar.server.component.handler.OperationHandler;
import com.castsoftware.sca.scar.server.component.service.ComponentEditService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/operations"}, produces={"application/json"})
public class OperationResource
implements OperationRequestVisitor {
    private final ComponentEditService componentService;

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Void> create(@Valid @RequestBody OperationRequest request) {
        request.accept((Object)this);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    public void visit(@NonNull ComponentMergeRequest request) {
        this.componentService.merge(request.getIds(), request.getName(), request.getDescription(), request.getSelectedId());
    }

    public void visit(@NonNull ComponentSplitRequest componentSplitRequest) {
        String componentId = componentSplitRequest.getId();
        switch (1.$SwitchMap$com$castsoftware$sca$scar$server$api$model$request$operation$SplitBy[componentSplitRequest.getBy().ordinal()]) {
            case 1: {
                this.componentService.split(componentId, OperationHandler.extensionMapper);
                break;
            }
            case 2: {
                this.componentService.split(componentId, OperationHandler.licenseMapper);
                break;
            }
            case 3: {
                this.componentService.split(componentId, OperationHandler.pathMapper);
                break;
            }
            case 4: {
                this.componentService.split(componentId, OperationHandler.versionMapper);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown split by: " + String.valueOf(componentSplitRequest.getBy()));
            }
        }
    }

    public void visit(@NonNull MoveFileComponentRequest moveFileComponentRequest) {
        this.componentService.moveFiles(moveFileComponentRequest.getFileIds(), moveFileComponentRequest.getDestinationId());
    }

    public void visit(@NonNull CreateFileComponentRequest createFileComponentRequest) {
        this.componentService.createFromFiles(createFileComponentRequest.getFileIds(), createFileComponentRequest.getName(), createFileComponentRequest.getDescription());
    }

    @Generated
    public OperationResource(ComponentEditService componentService) {
        this.componentService = componentService;
    }
}

