/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.api.util.ScarMediaType;
import com.castsoftware.sca.scar.server.system.dto.NavigableItemView;
import com.castsoftware.sca.scar.server.system.service.SystemService;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/navigate"}, produces={"application/json"})
public class NavigateResource {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(NavigateResource.class);
    private final SystemService service;

    @GetMapping(value={"/system-root"})
    public NavigableItemView getRoot() {
        return this.service.getSystemRootFolder();
    }

    @GetMapping(value={"/scanner-root"})
    public NavigableItemView getUserRoot() {
        return this.service.getScannerRootFolder();
    }

    @GetMapping(value={"/{itemId}"})
    public NavigableItemView getItem(@PathVariable @NotBlank String itemId) {
        return this.service.getFileSystemItem(itemId);
    }

    @GetMapping(value={"/{itemId}/parent"})
    public NavigableItemView getItemParent(@PathVariable @NotBlank String itemId) {
        return this.service.getItemParent(itemId);
    }

    @GetMapping(value={"/{itemId}/children"})
    public List<NavigableItemView> getItemChildren(@PathVariable @NotBlank String itemId, @RequestHeader HttpHeaders headers) {
        return this.service.getItemChildren(itemId, this.getExtensionFilter(headers));
    }

    @GetMapping(value={"{fromItemId}/to/{toItemId}"})
    public NavigableItemView getItemsBetween(@PathVariable @NotBlank String fromItemId, @PathVariable @NotBlank String toItemId, @RequestHeader HttpHeaders headers) {
        return this.service.getItemsBetween(fromItemId, toItemId, this.getExtensionFilter(headers));
    }

    private String getExtensionFilter(HttpHeaders headers) {
        return Opt.ofNullable((Object)headers).map(HttpHeaders::getContentType).filter(mt -> ScarMediaType.isCompatible((MediaType)ScarMediaType.APPLICATION_NAVIGATE_TYPE, (MediaType)mt)).map(mt -> (String)mt.getParameters().get("extension")).orElse(null);
    }

    @Generated
    public NavigateResource(SystemService service) {
        this.service = service;
    }
}

