/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.core.model.request.GetRequest;
import com.castsoftware.sca.scar.server.message.MessageResponse;
import com.castsoftware.sca.scar.server.message.MessageService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.Collection;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/messages"}, produces={"application/json"})
public class MessageResource {
    private final MessageService messageService;

    @GetMapping
    public Collection<MessageResponse> getAllMessages() {
        return this.messageService.getAllMessages();
    }

    @GetMapping(value={"/all"})
    public Collection<MessageResponse> getMessages(@Valid @ModelAttribute GetRequest request) {
        return this.messageService.getMessages(request);
    }

    @GetMapping(value={"/count"})
    public Long getMessageCount() {
        return this.messageService.getMessageCount();
    }

    @PostMapping(value={"/{messageId}/acknowledge"})
    public ResponseEntity<Void> acknowledgeMessage(@PathVariable @NotBlank String messageId) {
        this.messageService.acknowledgeMessage(messageId);
        return ResponseEntity.ok().build();
    }

    @Generated
    public MessageResource(MessageService messageService) {
        this.messageService = messageService;
    }
}

