/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.system.dto.LocaleView;
import com.castsoftware.sca.scar.server.system.transformer.LocaleTransformer;
import jakarta.validation.Valid;
import java.net.URI;
import java.util.Locale;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/system/locales"}, produces={"application/json"})
public class LocaleResource {
    @GetMapping(value={"/default"})
    public LocaleView getDefault() {
        return LocaleTransformer.from((Locale)Locale.getDefault());
    }

    @PutMapping(value={"/default"}, consumes={"application/json"})
    public ResponseEntity<Void> update(@Valid @RequestBody LocaleView view) {
        Optional.ofNullable(view).map(LocaleTransformer::from).ifPresent(Locale::setDefault);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getDefaultLocaleUri())).build();
    }

    private @NonNull URI getDefaultLocaleUri() {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((LocaleResource)MvcUriComponentsBuilder.on(this.getClass())).getDefault()).build().getPath());
    }
}

