/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.core.model.request.GetRequest;
import com.castsoftware.sca.scar.server.license.model.LicenseCategoryView;
import com.castsoftware.sca.scar.server.license.model.LicensePropertyView;
import com.castsoftware.sca.scar.server.license.model.LicenseView;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.license.model.request.LicenseCreateRequest;
import com.castsoftware.sca.scar.server.license.model.request.LicenseEditRequest;
import com.castsoftware.sca.scar.server.license.service.LicenseService;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.Collection;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/licenses"}, produces={"application/json"})
public class LicenseResource {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(LicenseResource.class);
    private final LicenseService licenseService;

    @PreAuthorize(value="hasRole('LICENSE_READ')")
    @GetMapping
    public Collection<? extends LightLicenseView> getLicenses(@RequestParam(defaultValue="false") boolean withDetails, @Valid @ModelAttribute GetRequest paginationRequest) {
        return withDetails ? this.licenseService.getLicensesWithDetails(paginationRequest) : this.licenseService.getLicenses(paginationRequest);
    }

    @GetMapping(value={"/count"})
    public Long countLicenses() {
        return this.licenseService.countLicenses();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_READ')")
    @GetMapping(value={"/{licenseId}"})
    public LicenseView getLicense(@PathVariable @NotBlank String licenseId) {
        return this.licenseService.getLicense(licenseId);
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<LightLicenseView> createLicense(@Valid @RequestBody LicenseCreateRequest request) {
        LightLicenseView view = this.licenseService.createLicense(request);
        return ResponseEntity.created((URI)this.getLicenseUri(view.getId())).body((Object)view);
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @PutMapping(value={"/{licenseId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateLicense(@PathVariable @NotBlank String licenseId, @Valid @RequestBody LicenseEditRequest request) {
        this.licenseService.editLicense(licenseId, request);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getLicenseUri(licenseId))).build();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_WRITE')")
    @DeleteMapping(value={"/{licenseId}"})
    public ResponseEntity<Void> deleteLicense(@PathVariable @NotBlank String licenseId) {
        this.licenseService.deleteLicense(licenseId);
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_READ')")
    @GetMapping(value={"/categories"})
    public Collection<LicenseCategoryView> getCategories() {
        return this.licenseService.getLicenseCategories();
    }

    @PreAuthorize(value="hasRole('VULNERABILITY_READ')")
    @GetMapping(value={"/properties"})
    public Collection<LicensePropertyView> getProperties() {
        return this.licenseService.getLicenseProperties();
    }

    private @NonNull URI getLicenseUri(@NonNull String accountId) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((LicenseResource)MvcUriComponentsBuilder.on(this.getClass())).getLicense(accountId)).build().getPath());
    }

    @Generated
    public LicenseResource(LicenseService licenseService) {
        this.licenseService = licenseService;
    }
}

