/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.license.model.LicensePolicyView;
import com.castsoftware.sca.scar.server.license.model.LightLicensePolicyView;
import com.castsoftware.sca.scar.server.license.model.request.ChangeDefaultPolicyRequest;
import com.castsoftware.sca.scar.server.license.model.request.PatchPolicyLinkRequest;
import com.castsoftware.sca.scar.server.license.model.request.PolicyCreateRequest;
import com.castsoftware.sca.scar.server.license.model.request.PolicyEditRequest;
import com.castsoftware.sca.scar.server.license.service.LicensePolicyService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/policies"}, produces={"application/json"})
public class LicensePolicyResource {
    private final LicensePolicyService licensePolicyService;

    @PreAuthorize(value="hasRole('LICENSE_READ')")
    @GetMapping
    public Collection<LightLicensePolicyView> getLicensePolicies() {
        return this.licensePolicyService.getPolicies();
    }

    @PreAuthorize(value="hasRole('LICENSE_READ')")
    @GetMapping(value={"/{licensePolicyId}"})
    public LicensePolicyView getLicensePolicy(@PathVariable @NotBlank String licensePolicyId) {
        return this.licensePolicyService.getPolicy(licensePolicyId);
    }

    @PreAuthorize(value="hasRole('LICENSE_WRITE')")
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<LightLicensePolicyView> createPolicy(@Valid @RequestBody PolicyCreateRequest request) {
        LightLicensePolicyView view = this.licensePolicyService.createPolicy(request);
        return ResponseEntity.created((URI)this.getPolicyUri(view.getId())).body((Object)view);
    }

    @PreAuthorize(value="hasRole('LICENSE_WRITE')")
    @PutMapping(value={"/{licensePolicyId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateLicensePolicy(@PathVariable @NotBlank String licensePolicyId, @Valid @RequestBody PolicyEditRequest request) {
        this.licensePolicyService.editPolicy(licensePolicyId, request);
        return this.accepted(licensePolicyId);
    }

    @PreAuthorize(value="hasRole('LICENSE_WRITE')")
    @PatchMapping(value={"/{licensePolicyId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updatePolicyLicense(@PathVariable @NotBlank String licensePolicyId, @Valid @RequestBody PatchPolicyLinkRequest request) {
        Optional.ofNullable(request.getPolicyRemoveLicenseRequest()).ifPresent(req -> this.licensePolicyService.removeLicense(licensePolicyId, req));
        Optional.ofNullable(request.getPolicyUpdateLicenseRequest()).ifPresent(req -> this.licensePolicyService.addOrUpdateLicense(licensePolicyId, req));
        return this.accepted(licensePolicyId);
    }

    @PreAuthorize(value="hasRole('LICENSE_WRITE')")
    @DeleteMapping(value={"/{licensePolicyId}"})
    public ResponseEntity<Void> deleteLicensePolicy(@PathVariable @NotBlank String licensePolicyId) {
        this.licensePolicyService.deletePolicy(licensePolicyId);
        return ResponseEntity.accepted().build();
    }

    @GetMapping(value={"/default"})
    public LightLicensePolicyView getDefaultLicensePolicy() {
        return this.licensePolicyService.getDefaultPolicy();
    }

    @PreAuthorize(value="hasRole('LICENSE_WRITE')")
    @PatchMapping(value={"/default"}, consumes={"application/json"})
    public ResponseEntity<Void> updateDefaultLicensePolicy(@Valid @RequestBody ChangeDefaultPolicyRequest request) {
        this.licensePolicyService.setDefaultPolicy(request.getNewDefaultId());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getDefaultPolicyUri())).build();
    }

    private @NonNull URI getPolicyUri(@NonNull String licensePolicyId) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((LicensePolicyResource)MvcUriComponentsBuilder.on(this.getClass())).getLicensePolicy(licensePolicyId)).build().getPath());
    }

    private @NonNull URI getDefaultPolicyUri() {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((LicensePolicyResource)MvcUriComponentsBuilder.on(this.getClass())).getDefaultLicensePolicy()).build().getPath());
    }

    private @NonNull ResponseEntity<Void> accepted(@NonNull String licensePolicyId) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getPolicyUri(licensePolicyId))).build();
    }

    @Generated
    public LicensePolicyResource(LicensePolicyService licensePolicyService) {
        this.licensePolicyService = licensePolicyService;
    }
}

