/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.bom.model.BomView;
import com.castsoftware.sca.scar.server.global.model.FieldSelector;
import com.castsoftware.sca.scar.server.global.model.GlobalKPIView;
import com.castsoftware.sca.scar.server.global.service.GlobalService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Validated
@RequestMapping(value={"/resources/global"}, produces={"application/json"})
public class GlobalResource {
    private final GlobalService globalService;

    @GetMapping(value={"/kpis"})
    public GlobalKPIView getGlobalKPIs() {
        return this.globalService.getGlobalKPIs();
    }

    @GetMapping(value={"/latest"})
    public List<BomView> getLatestBoms(@RequestParam(defaultValue="CREATED") String filter) {
        FieldSelector fieldSelector = FieldSelector.stream().filter(f -> f.name().equals(filter)).findAny().orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST));
        return this.globalService.getLatestBoms(fieldSelector);
    }

    @Generated
    public GlobalResource(GlobalService globalService) {
        this.globalService = globalService;
    }
}

