/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.bom.model.request.FileUpdateRequest;
import com.castsoftware.sca.scar.server.bom.service.FileService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.util.Collection;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/files"}, produces={"application/json"})
public class FileResource {
    private final FileService fileService;

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping
    public Collection<FileView> getFilesWithSha256(@RequestParam @NotBlank String sha256, @RequestParam(defaultValue="false") boolean onlyBoms) {
        return this.fileService.searchBySha256(sha256, onlyBoms);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{fileId}"})
    public FileView getFile(@PathVariable @NotBlank String fileId, @RequestParam(defaultValue="false") boolean full) {
        return this.fileService.getFile(fileId, full);
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PutMapping(value={"/{fileId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateFile(@PathVariable @NotBlank String fileId, @Valid @RequestBody FileUpdateRequest request) {
        this.fileService.updateFile(fileId, request);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getFileUri(fileId))).build();
    }

    private @NonNull URI getFileUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((FileResource)MvcUriComponentsBuilder.on(this.getClass())).getFile(id, false)).build().getPath());
    }

    @Generated
    public FileResource(FileService fileService) {
        this.fileService = fileService;
    }
}

