/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.bom.model.build.BomBuildExecutorView;
import com.castsoftware.sca.scar.server.bom.model.build.BomBuildTaskView;
import com.castsoftware.sca.scar.server.bom.model.export.BomExportExecutorView;
import com.castsoftware.sca.scar.server.bom.model.export.BomExportTaskView;
import com.castsoftware.sca.scar.server.bom.service.BomTaskService;
import jakarta.validation.constraints.NotBlank;
import java.util.Collection;
import lombok.Generated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/executors"}, produces={"application/json"})
public class ExecutorResource {
    private final BomTaskService bomTaskService;

    @GetMapping(value={"/bom/builder"})
    public BomBuildExecutorView getBomBuilder() {
        return this.bomTaskService.getBomBuildExecutor();
    }

    @GetMapping(value={"/bom/builder/builds"})
    public Collection<BomBuildTaskView> getBomBuilds() {
        return this.bomTaskService.getBomBuildTasks();
    }

    @GetMapping(value={"/bom/builder/builds/{bomBuildId}"})
    public BomBuildTaskView getBomBuild(@PathVariable @NotBlank String bomBuildId) {
        return this.bomTaskService.getBomBuildTask(bomBuildId);
    }

    @GetMapping(value={"/bom/exporter"})
    public BomExportExecutorView getBomExporter() {
        return this.bomTaskService.getBomExportExecutor();
    }

    @GetMapping(value={"/bom/exports"})
    public Collection<BomExportTaskView> getBomExports() {
        return this.bomTaskService.getBomExportTasks();
    }

    @GetMapping(value={"/bom/exports/{bomId}"})
    public BomExportTaskView getBomExport(@PathVariable @NotBlank String bomId) {
        return this.bomTaskService.getBomExportTask(bomId);
    }

    @Generated
    public ExecutorResource(BomTaskService bomTaskService) {
        this.bomTaskService = bomTaskService;
    }
}

