/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.api.model.ApiError;
import com.castsoftware.sca.scar.server.api.model.DependenciesFilter;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.component.model.DependencyView;
import com.castsoftware.sca.scar.server.component.model.request.FullUpdateRequest;
import com.castsoftware.sca.scar.server.component.service.ComponentEditService;
import com.castsoftware.sca.scar.server.component.service.ComponentReadService;
import com.castsoftware.sca.util.java.Opt;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/components"}, produces={"application/json"})
public class ComponentResource {
    private final ComponentReadService componentReadService;
    private final ComponentEditService componentEditService;

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{componentId}"})
    public ComponentView getComponent(@PathVariable @NotBlank String componentId) {
        return this.componentReadService.get(componentId);
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PutMapping(value={"/{componentId}"}, consumes={"application/json"})
    public ResponseEntity<Void> updateComponent(@PathVariable @NotBlank String componentId, @Valid @RequestBody FullUpdateRequest request) {
        this.componentEditService.updateComponent(componentId, request);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getComponentUri(componentId))).build();
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @DeleteMapping(value={"/{componentId}"})
    public ResponseEntity<Void> deleteComponent(@PathVariable @NotBlank String componentId) {
        this.componentEditService.deleteComponent(componentId);
        return ResponseEntity.noContent().build();
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PutMapping(value={"/{componentId}/rescan"})
    public ResponseEntity<?> rescanComponent(@PathVariable @NotBlank String componentId) {
        String id = this.componentEditService.rescanComponent(componentId);
        if (id == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)ApiError.builder().status(HttpStatus.SERVICE_UNAVAILABLE.value()).code("task_executor_busy").message("Unable to execute task. Executor is currently busy.").timestamp(Instant.now()).build());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.PARTIAL_CONTENT).location(this.getComponentUri(componentId))).build();
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{componentId}/dependencies"}, consumes={"application/json"})
    public Collection<DependencyView> getDependencies(@PathVariable @NotBlank String componentId, @Valid @RequestBody(required=false) DependenciesFilter filter) {
        return Optional.ofNullable(filter).map(DependenciesFilter::getComponentVersion).flatMap(Opt::ofBlankString).map(cv -> this.componentReadService.getDependencies(componentId, cv)).orElseGet(() -> this.componentReadService.getDependencies(componentId));
    }

    private @NonNull URI getComponentUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((ComponentResource)MvcUriComponentsBuilder.on(this.getClass())).getComponent(id)).build().getPath());
    }

    @Generated
    public ComponentResource(ComponentReadService componentReadService, ComponentEditService componentEditService) {
        this.componentReadService = componentReadService;
        this.componentEditService = componentEditService;
    }
}

