/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.api.model.request.catalog.CatalogRequest;
import com.castsoftware.sca.scar.server.bom.model.CatalogView;
import com.castsoftware.sca.scar.server.bom.service.CatalogService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/catalogs"}, produces={"application/json"})
public class CatalogResource {
    private final CatalogService catalogService;

    @PreAuthorize(value="hasRole('CATALOG_READ')")
    @GetMapping(value={"/central"})
    public CatalogView getCatalog() {
        return this.catalogService.getCatalog();
    }

    @PreAuthorize(value="hasRole('CATALOG_WRITE')")
    @PatchMapping(value={"/central"}, consumes={"application/json"})
    public ResponseEntity<Void> addOrRemoveComponent(@Valid @RequestBody CatalogRequest request) {
        this.catalogService.updateCatalog(request);
        return ResponseEntity.accepted().build();
    }

    @Generated
    public CatalogResource(CatalogService catalogService) {
        this.catalogService = catalogService;
    }
}

