/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.api.model.ApiError;
import com.castsoftware.sca.scar.server.api.request.SearchFromType;
import com.castsoftware.sca.scar.server.api.resource.ExecutorResource;
import com.castsoftware.sca.scar.server.bom.model.BomView;
import com.castsoftware.sca.scar.server.bom.model.CategoryView;
import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.bom.model.FolderView;
import com.castsoftware.sca.scar.server.bom.model.NodeView;
import com.castsoftware.sca.scar.server.bom.model.request.BomBuildRequest;
import com.castsoftware.sca.scar.server.bom.model.request.BomExportRequest;
import com.castsoftware.sca.scar.server.bom.model.request.BomPatchRequest;
import com.castsoftware.sca.scar.server.bom.service.BomService;
import com.castsoftware.sca.scar.server.bom.service.BomTaskService;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.component.model.request.CreateComponentRequest;
import com.castsoftware.sca.scar.server.component.service.ComponentEditService;
import com.castsoftware.sca.scar.server.core.model.request.GetRequest;
import com.castsoftware.sca.scar.server.kpi.model.KPIsView;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/resources/boms"}, produces={"application/json"})
public class BomResource {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(BomResource.class);
    private final BomService bomService;
    private final BomTaskService bomTaskService;
    private final ComponentEditService componentEditService;

    @GetMapping
    public Collection<BomView> getBoms() {
        return this.bomService.getAllBoms();
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}"})
    public BomView getBom(@PathVariable @NotBlank String bomId) {
        return this.bomService.getBom(bomId);
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PatchMapping(value={"/{bomId}"}, consumes={"application/json"})
    public ResponseEntity<BomView> updateBom(@PathVariable @NotBlank String bomId, @Valid @RequestBody BomPatchRequest request) {
        Optional.ofNullable(request.getChangeCategory()).ifPresent(cc -> this.bomService.updateComponentsCategory(bomId, cc));
        Optional.ofNullable(request.getChangePolicyRequest()).ifPresent(cpr -> this.bomService.updateLicensePolicy(bomId, cpr.getPolicyId()));
        Optional.ofNullable(request.getChangeReviewStep()).ifPresent(crs -> this.bomService.updateBomReviewStep(bomId, crs.getStep()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(this.getBomUri(bomId))).build();
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PostMapping(value={"/upload/{sourceType}"}, consumes={"multipart/form-data"})
    public ResponseEntity<Map<String, String>> uploadBomArchive(@PathVariable String sourceType, @RequestParam(value="file") MultipartFile file) throws IOException {
        String originalFileName = file.getOriginalFilename();
        InputStream fileInputStream = file.getInputStream();
        String fileId = this.bomTaskService.processBomArchiveUpload(sourceType, originalFileName, fileInputStream);
        return ResponseEntity.ok().body(Collections.singletonMap("fileId", fileId));
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PostMapping(consumes={"application/json"})
    public ResponseEntity<?> createBom(@Valid @RequestBody BomBuildRequest request) {
        String id = this.bomTaskService.createBomBuildTask(request);
        if (id == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).body((Object)ApiError.builder().status(HttpStatus.SERVICE_UNAVAILABLE.value()).code("task_executor_busy").message("Unable to execute task. Executor is currently busy.").timestamp(Instant.now()).build());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.PARTIAL_CONTENT).location(this.getBomBuildUri(id))).build();
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @DeleteMapping(value={"/{bomId}"})
    public ResponseEntity<Void> deleteBom(@PathVariable @NotBlank String bomId) {
        this.bomTaskService.createBomDeleteTask(bomId);
        return ResponseEntity.accepted().build();
    }

    @GetMapping(value={"/search"})
    public Collection<BomView> searchBomsLinkedTo(@RequestParam @NotBlank String linkedId, @RequestParam SearchFromType from) {
        if (SearchFromType.CATALOG.equals((Object)from)) {
            return this.bomService.searchBomFromComponent(linkedId);
        }
        if (SearchFromType.VULNERABILITY.equals((Object)from)) {
            return this.bomService.searchBomFromVulnerability(linkedId);
        }
        return this.bomService.searchBomFromLicense(linkedId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/categories"})
    public Collection<CategoryView> getCategories(@PathVariable @NotBlank String bomId) {
        return this.bomService.getCategories(bomId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/categories/{categoryName}/components"})
    public Collection<ComponentView> getCategoryComponents(@PathVariable @NotBlank String bomId, @PathVariable @NotBlank String categoryName, @Valid @ModelAttribute GetRequest req) {
        return this.bomService.getComponents(bomId, categoryName, Objects.requireNonNullElseGet(req, GetRequest::new));
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/components"})
    public Collection<ComponentView> getComponents(@PathVariable @NotBlank String bomId, @Valid @ModelAttribute GetRequest req) {
        return this.bomService.getComponents(bomId, Objects.requireNonNullElseGet(req, GetRequest::new));
    }

    @PreAuthorize(value="hasRole('BOM_WRITE')")
    @PostMapping(value={"/{bomId}/components"}, consumes={"application/json"})
    public ResponseEntity<Void> createComponent(@PathVariable @NotBlank String bomId, @Valid @RequestBody CreateComponentRequest request) {
        this.componentEditService.createNewComponent(bomId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/components/{componentId}"})
    public ComponentView getComponent(@PathVariable @NotBlank String bomId, @PathVariable @NotBlank String componentId) {
        return this.bomService.getComponent(bomId, componentId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/components/{componentId}/files"})
    public Collection<FileView> getFiles(@PathVariable @NotBlank String bomId, @PathVariable @NotBlank String componentId) {
        return this.bomService.getComponentFiles(bomId, componentId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/nodes/root"})
    public FolderView getRootNode(@PathVariable @NotBlank String bomId) {
        return this.bomService.getRootNode(bomId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/nodes/{nodeId}/children"})
    public Collection<NodeView> getNodeChildren(@PathVariable @NotBlank String bomId, @PathVariable @NotBlank String nodeId) {
        return this.bomService.getNodeChildren(bomId, nodeId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/compliances"})
    public Collection<LightLicenseView> getCompliances(@PathVariable @NotBlank String bomId) {
        return this.bomService.getCompliances(bomId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @GetMapping(value={"/{bomId}/kpis"})
    public KPIsView getKpis(@PathVariable @NotBlank String bomId) {
        return this.bomService.getKpis(bomId);
    }

    @PreAuthorize(value="hasRole('BOM_READ')")
    @PostMapping(value={"/{bomId}/export"}, consumes={"application/json"})
    public ResponseEntity<Void> exportBom(@PathVariable @NotBlank String bomId, @Valid @RequestBody BomExportRequest request) {
        String taskId;
        try {
            taskId = this.bomTaskService.createBomExportTask(bomId, request);
        }
        catch (IllegalAccessException | JSONException e) {
            LOGGER.error("fail to export BOM", e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.PARTIAL_CONTENT).location(this.getBomExportUri(taskId))).build();
    }

    private @NonNull URI getBomUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((BomResource)MvcUriComponentsBuilder.on(this.getClass())).getBom(id)).build().getPath());
    }

    private @NonNull URI getBomBuildUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((ExecutorResource)MvcUriComponentsBuilder.on(ExecutorResource.class)).getBomBuild(id)).build().getPath());
    }

    private @NonNull URI getBomExportUri(@NonNull String id) {
        return URI.create(MvcUriComponentsBuilder.fromMethodCall((Object)((ExecutorResource)MvcUriComponentsBuilder.on(ExecutorResource.class)).getBomExport(id)).build().getPath());
    }

    @Generated
    public BomResource(BomService bomService, BomTaskService bomTaskService, ComponentEditService componentEditService) {
        this.bomService = bomService;
        this.bomTaskService = bomTaskService;
        this.componentEditService = componentEditService;
    }
}

