/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.resource;

import com.castsoftware.sca.scar.server.api.handler.DisconnectBroadcaster;
import com.castsoftware.sca.scar.server.application.configuration.MutableProperties;
import com.castsoftware.sca.scar.server.application.domain.ApplicationConnectionType;
import com.castsoftware.sca.scar.server.application.exception.MultiUserModeProhibitedException;
import com.castsoftware.sca.scar.server.application.model.request.AbstractLinkSamAccountRequest;
import com.castsoftware.sca.scar.server.application.model.request.LinkExistingSamAccountRequest;
import com.castsoftware.sca.scar.server.application.model.request.LinkNewSamAccountRequest;
import com.castsoftware.sca.scar.server.application.model.request.UpdateAuthenticationModeRequest;
import com.castsoftware.sca.scar.server.application.model.response.ServerConfigurationResponse;
import com.castsoftware.sca.scar.server.application.service.ApplicationService;
import com.castsoftware.sca.scar.server.sam.domain.SBomConfiguration;
import com.castsoftware.sca.scar.server.sam.domain.SamAccount;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkState;
import com.castsoftware.sca.scar.server.sam.handler.SamLinkContext;
import com.castsoftware.sca.scar.server.sam.model.request.SamPasswordResetRequest;
import com.castsoftware.sca.scar.server.sam.model.request.SamResetLinkRequest;
import com.castsoftware.sca.scar.server.sam.model.request.SamSignUpRequest;
import com.castsoftware.sca.scar.server.sam.model.response.SamLinkStateResponse;
import com.castsoftware.sca.scar.server.sam.service.SamAccountService;
import com.castsoftware.sca.scar.server.util.BeanValidatorUtil;
import jakarta.validation.Valid;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Validated
@RequestMapping(value={"/resources/application"}, produces={"application/json"})
public class ApplicationResource
implements AbstractLinkSamAccountRequest.LinkSamAccountRequestVisitor {
    private final ApplicationContext context;
    private final DisconnectBroadcaster disconnectBroadcaster;
    private final SamAccountService samAccountService;
    private final ApplicationService applicationService;

    @PostMapping(value={"/initialize"}, consumes={"application/json"})
    public ResponseEntity<?> initialize(@Valid @RequestBody AbstractLinkSamAccountRequest request) {
        return request.linkSamAccount((AbstractLinkSamAccountRequest.LinkSamAccountRequestVisitor)this);
    }

    public ResponseEntity<?> linkNewSamAccount(@NonNull LinkNewSamAccountRequest request) {
        return Optional.of(request).map(ApplicationResource::toSamSignUpRequest).map(arg_0 -> ((SamAccountService)this.samAccountService).linkNewAccount(arg_0)).map(config -> this.applicationService.createAndSaveConfiguration(config, request.getPassword())).map(arg_0 -> this.successfullyLinked(arg_0)).orElseGet(() -> ResponseEntity.badRequest().build());
    }

    private static SamSignUpRequest toSamSignUpRequest(@NonNull LinkNewSamAccountRequest request) {
        return SamSignUpRequest.builder().firstName(request.getFirstName()).lastName(request.getLastName()).email(request.getEmail()).password(request.getPassword()).build();
    }

    public ResponseEntity<?> linkExistingSamAccount(@NonNull LinkExistingSamAccountRequest request) {
        return Optional.of(request).map(req -> this.samAccountService.linkExistingSamAccount(req.getEmail(), req.getPassword())).map(cred -> this.applicationService.createAndSaveConfiguration(cred, request.getPassword())).map(arg_0 -> this.successfullyLinked(arg_0)).orElseGet(() -> ResponseEntity.badRequest().build());
    }

    private @NonNull ResponseEntity<Void> successfullyLinked(MutableProperties config) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @GetMapping(value={"/sam-link"})
    public ResponseEntity<?> getLinkedSamAccount() {
        return Optional.of(this.samAccountService.getLinkState()).map(linkState -> new SamLinkStateResponse(linkState.getLinkStatus().name().toLowerCase(), linkState.getSamAccount())).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.internalServerError().build());
    }

    @PutMapping(value={"/linked-account/reset"}, consumes={"application/json"})
    public ResponseEntity<?> resetLinkedSamAccount(@Valid @RequestBody SamResetLinkRequest request) {
        return Optional.of(request).map(req -> this.samAccountService.resetSamAccount(request.getPassword())).map(arg_0 -> ((ApplicationService)this.applicationService).updateConfiguration(arg_0)).map(arg_0 -> this.successfullyLinked(arg_0)).orElseGet(() -> ResponseEntity.badRequest().build());
    }

    @PreAuthorize(value="hasRole('USER_WRITE')")
    @PutMapping(value={"/connection-type"}, consumes={"application/json"})
    public ResponseEntity<Void> updateConnectionType(@Valid @RequestBody UpdateAuthenticationModeRequest request) {
        BeanValidatorUtil.validate((Object)request);
        ApplicationConnectionType connectionType = (ApplicationConnectionType)EnumUtils.getEnum(ApplicationConnectionType.class, (String)request.getConnectionType().toUpperCase());
        this.checkMultiUserModesAreAllowed();
        this.applicationService.updateAuthenticationMode(connectionType, request.getMetadataUrl());
        return ResponseEntity.accepted().build();
    }

    private void checkMultiUserModesAreAllowed() {
        Optional.of(SamLinkContext.get()).map(SamLinkState::getSamAccount).map(SamAccount::getSbomConfiguration).map(SBomConfiguration::getMaxUsers).filter(maxUsers -> maxUsers > 0).orElseThrow(MultiUserModeProhibitedException::new);
    }

    @PostMapping(value={"/requestSamPasswordReset"})
    public ResponseEntity<Void> requestSamPasswordReset(@Valid @RequestBody SamPasswordResetRequest request) {
        this.samAccountService.requestPasswordReset(request);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/configuration"})
    public ServerConfigurationResponse getConfiguration() {
        return this.applicationService.getConfiguration();
    }

    @DeleteMapping
    public void close() {
        this.disconnectBroadcaster.notifyDisconnect();
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    @Generated
    public ApplicationResource(ApplicationContext context, DisconnectBroadcaster disconnectBroadcaster, SamAccountService samAccountService, ApplicationService applicationService) {
        this.context = context;
        this.disconnectBroadcaster = disconnectBroadcaster;
        this.samAccountService = samAccountService;
        this.applicationService = applicationService;
    }
}

