/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.provider;

import com.castsoftware.sca.scar.server.api.exception.CannotOverwriteConfigException;
import com.castsoftware.sca.scar.server.api.exception.ServerNotInitializedException;
import com.castsoftware.sca.scar.server.api.model.ApiError;
import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.domain.ApplicationMode;
import com.castsoftware.sca.scar.server.core.component.ServerStatusHolder;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Predicates;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ServerStateFilter
extends OncePerRequestFilter {
    private final ScarServerProperties scarServerProperties;
    private final ServerStatusHolder serverStatusHolder;
    private final ObjectMapper objectMapper;

    public ServerStateFilter(ScarServerProperties scarServerProperties, ServerStatusHolder serverStatusHolder, ObjectMapper objectMapper) {
        this.scarServerProperties = (ScarServerProperties)Guards.notNull((Object)scarServerProperties, IllegalStateException::new);
        this.serverStatusHolder = serverStatusHolder;
        this.objectMapper = objectMapper;
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        ServerStatusHolder.ServerStatus status = this.serverStatusHolder.getStatus();
        ApplicationMode mode = this.scarServerProperties.getMode();
        if (!ServerStatusHolder.ServerStatus.READY.equals((Object)status) && !ServerStateFilter.isInternationalizationRequest((HttpServletRequest)request)) {
            this.respondServerNotReady(response);
            return;
        }
        if (ApplicationMode.UNINITIALIZED.equals((Object)mode) && ServerStateFilter.forbiddenWhenUninitialized((HttpServletRequest)request).booleanValue()) {
            throw new ServerNotInitializedException();
        }
        if (ApplicationMode.INITIALIZED.equals((Object)mode) && ServerStateFilter.forbiddenWhenInitialized((HttpServletRequest)request).booleanValue()) {
            throw new CannotOverwriteConfigException();
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void respondServerNotReady(@NonNull HttpServletResponse response) throws IOException {
        response.setStatus(503);
        response.setContentType("application/json");
        ApiError error = ApiError.builder().status(HttpStatus.SERVICE_UNAVAILABLE.value()).code("server_not_ready").message("Server is unavailable").timestamp(Instant.now()).build();
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)error));
    }

    private static @NonNull Boolean forbiddenWhenUninitialized(HttpServletRequest request) {
        return Optional.of(request).filter(Predicates.wrap(ServerStateFilter::isSseRequest).or(ServerStateFilter::isInitializingRequest).or(ServerStateFilter::isInternationalizationRequest).or(ServerStateFilter::isStaticResourceRequest).negate()).isPresent();
    }

    private static @NonNull Boolean forbiddenWhenInitialized(@NonNull HttpServletRequest request) {
        return Optional.of(request).filter(Predicates.wrap(ServerStateFilter::isInitializationRequest)).isPresent();
    }

    private static boolean isInternationalizationRequest(@NonNull HttpServletRequest request) {
        return Optional.of(request).filter(ServerStateFilter.httpMethods((HttpMethod[])new HttpMethod[]{HttpMethod.GET})).filter(ServerStateFilter.pathStartsWith((String[])new String[]{"/resources/system/bundles", "/resources/system/locales"})).isPresent();
    }

    private static @NonNull Boolean isSseRequest(@NonNull HttpServletRequest request) {
        return Optional.of(request).filter(ServerStateFilter.httpMethods((HttpMethod[])new HttpMethod[]{HttpMethod.GET})).filter(ServerStateFilter.pathStartsWith((String[])new String[]{"/resources/sse"})).isPresent();
    }

    private static @NonNull Boolean isInitializingRequest(@NonNull HttpServletRequest request) {
        return Optional.of(request).filter(ServerStateFilter.httpMethods((HttpMethod[])new HttpMethod[]{HttpMethod.GET, HttpMethod.POST})).filter(ServerStateFilter.pathStartsWith((String[])new String[]{"/resources/application"})).isPresent();
    }

    private static @NonNull Boolean isInitializationRequest(@NonNull HttpServletRequest request) {
        return Optional.of(request).filter(ServerStateFilter.httpMethods((HttpMethod[])new HttpMethod[]{HttpMethod.POST})).filter(ServerStateFilter.pathStartsWith((String[])new String[]{"/resources/application"})).isPresent();
    }

    private static @NonNull Boolean isStaticResourceRequest(@NonNull HttpServletRequest request) {
        return Optional.of(request).filter(ServerStateFilter.httpMethods((HttpMethod[])new HttpMethod[]{HttpMethod.GET})).filter(req -> {
            String contextPath = req.getContextPath();
            String servletPath = req.getServletPath();
            String uri = req.getRequestURI();
            String path = uri.substring(contextPath.length() + servletPath.length());
            return !path.startsWith("/resources");
        }).isPresent();
    }

    private static @NonNull Predicate<HttpServletRequest> httpMethods(HttpMethod ... methods) {
        return req -> Arrays.stream(methods).anyMatch(method -> method.name().equals(req.getMethod()));
    }

    private static @NonNull Predicate<HttpServletRequest> pathStartsWith(String ... path) {
        return crc -> Optional.ofNullable(crc).map(req -> {
            String contextPath = req.getContextPath();
            String uri = req.getRequestURI();
            return contextPath.isEmpty() ? uri : uri.substring(contextPath.length());
        }).filter(p -> Arrays.stream(path).anyMatch(p::startsWith)).isPresent();
    }
}

