/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.handler;

import com.castsoftware.sca.scar.server.api.handler.ServerBroadcaster;
import com.castsoftware.sca.scar.server.api.model.ServerMessageEvent;
import com.castsoftware.sca.scar.server.api.model.ServerMessageEventType;
import com.castsoftware.sca.scar.server.bom.domain.BomBuild;
import com.castsoftware.sca.scar.server.bom.model.build.BomBuildExecutorView;
import com.castsoftware.sca.scar.server.bom.transformer.Builds;
import com.castsoftware.sca.scar.server.util.task.Task;
import com.castsoftware.sca.scar.server.util.task.TaskEventListener;
import java.util.Optional;

public class BomBuildBroadcaster
extends ServerBroadcaster<BomBuildBroadcaster>
implements TaskEventListener {
    public <T extends Task> void finish(T build) {
        this.extractTask(build).map(b -> new ServerMessageEvent(ServerMessageEventType.finish_bom_build.name(), (Object)Builds.base((BomBuild)b))).ifPresent(arg_0 -> ((BomBuildBroadcaster)this).broadcast(arg_0));
    }

    public <T extends Task> void update(T build) {
        this.extractTask(build).map(b -> new ServerMessageEvent(ServerMessageEventType.update_bom_build.name(), (Object)Builds.monitor((BomBuild)b))).ifPresent(arg_0 -> ((BomBuildBroadcaster)this).broadcast(arg_0));
    }

    public void updateExecutorStatus(boolean busy) {
        this.broadcast(new ServerMessageEvent(ServerMessageEventType.update_builder_status.name(), (Object)new BomBuildExecutorView(!busy)));
    }

    private Optional<BomBuild> extractTask(Task task) {
        return Optional.ofNullable(task).filter(BomBuild.class::isInstance).map(BomBuild.class::cast);
    }
}

