/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.exception.handler;

import com.castsoftware.sca.scar.server.api.model.ApiError;
import com.castsoftware.sca.scar.server.api.model.ApiValidatorError;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Order(value=-2147483648)
@RestControllerAdvice
public class SpringMvcExceptionHandler
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SpringMvcExceptionHandler.class);

    protected ResponseEntity<Object> handleHttpMessageNotReadable(@NonNull HttpMessageNotReadableException ex, @NonNull HttpHeaders headers, @NonNull HttpStatusCode status, @NonNull WebRequest request) {
        LOGGER.error("Request failed: {}", (Object)ex.getMessage(), (Object)ex);
        ApiError apiError = ApiError.builder().status(HttpStatus.BAD_REQUEST.value()).code("missing_or_unreadable_body").message("Required request body is missing or cannot be read").timestamp(Instant.now()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)apiError);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(@NonNull MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatusCode status, @NonNull WebRequest request) {
        LOGGER.error("Validation failed: {}", (Object)ex.getMessage(), (Object)ex);
        List<ApiValidatorError.ValidationError> validationErrors = ex.getBindingResult().getFieldErrors().stream().map(arg_0 -> this.buildValidationError(arg_0)).toList();
        ApiValidatorError apiValidatorError = ApiValidatorError.builder().timestamp(Instant.now()).details(validationErrors).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)apiValidatorError);
    }

    protected ResponseEntity<Object> handleHandlerMethodValidationException(@NonNull HandlerMethodValidationException ex, @NonNull HttpHeaders headers, @NonNull HttpStatusCode status, @NonNull WebRequest request) {
        LOGGER.error("Validation failed: {}", (Object)ex.getMessage(), (Object)ex);
        List validationErrors = ex.getParameterValidationResults().stream().flatMap(result -> result.getResolvableErrors().stream().map(error -> ApiValidatorError.ValidationError.builder().path(result.getMethodParameter().getParameterName()).error(error.getDefaultMessage()).build())).toList();
        ApiValidatorError apiValidatorError = ApiValidatorError.builder().timestamp(Instant.now()).details(validationErrors).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)apiValidatorError);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ApiValidatorError> handleConstraintViolationException(@NonNull ConstraintViolationException ex) {
        LOGGER.error("Validation failed: {}", (Object)ex.getMessage(), (Object)ex);
        List<ApiValidatorError.ValidationError> validationErrors = ex.getConstraintViolations().stream().map(arg_0 -> this.buildValidationError(arg_0)).toList();
        ApiValidatorError apiValidatorError = ApiValidatorError.builder().timestamp(Instant.now()).details(validationErrors).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)apiValidatorError);
    }

    private ApiValidatorError.ValidationError buildValidationError(@NonNull ConstraintViolation<?> violation) {
        return ApiValidatorError.ValidationError.builder().path(violation.getPropertyPath().toString()).error(violation.getMessage()).build();
    }

    private ApiValidatorError.ValidationError buildValidationError(@NonNull FieldError fieldError) {
        return ApiValidatorError.ValidationError.builder().path(fieldError.getField()).error(fieldError.getDefaultMessage()).build();
    }
}

