/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.exception.handler;

import com.castsoftware.sca.scar.server.api.model.ApiError;
import com.castsoftware.sca.scar.server.core.exception.AbstractScarException;
import com.castsoftware.sca.scar.server.core.exception.ConflictException;
import com.castsoftware.sca.scar.server.core.exception.ForbiddenException;
import com.castsoftware.sca.scar.server.core.exception.InvalidArgumentException;
import com.castsoftware.sca.scar.server.core.exception.InvalidStateException;
import com.castsoftware.sca.scar.server.core.exception.NotAllowedException;
import com.castsoftware.sca.scar.server.core.exception.ResourceNotFoundException;
import com.castsoftware.sca.scar.server.core.exception.UnauthorisedException;
import com.castsoftware.sca.scar.server.core.exception.UnavailableException;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=-2147483648)
@RestControllerAdvice
public class ScarExceptionHandler {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ScarExceptionHandler.class);
    private static final Map<Class<? extends AbstractScarException>, HttpStatus> EXCEPTION_MAPPING = Map.of(InvalidArgumentException.class, HttpStatus.BAD_REQUEST, ResourceNotFoundException.class, HttpStatus.NOT_FOUND, ConflictException.class, HttpStatus.CONFLICT, UnauthorisedException.class, HttpStatus.UNAUTHORIZED, ForbiddenException.class, HttpStatus.FORBIDDEN, InvalidStateException.class, HttpStatus.INTERNAL_SERVER_ERROR, NotAllowedException.class, HttpStatus.METHOD_NOT_ALLOWED, UnavailableException.class, HttpStatus.SERVICE_UNAVAILABLE);

    @ExceptionHandler(value={AbstractScarException.class})
    public ResponseEntity<ApiError> handleScarException(@NonNull AbstractScarException exception) {
        LOGGER.error("Request failed: {}", (Object)exception.getMessage(), (Object)exception);
        HttpStatus httpStatus = this.getStatusForException(exception);
        ApiError apiError = ApiError.builder().status(httpStatus.value()).code(exception.getCode()).message(exception.getMessage()).timestamp(Instant.now()).build();
        return ResponseEntity.status((HttpStatusCode)httpStatus).body((Object)apiError);
    }

    private HttpStatus getStatusForException(@NonNull AbstractScarException exception) {
        return EXCEPTION_MAPPING.keySet().stream().filter(exceptionClass -> exceptionClass.isAssignableFrom(exception.getClass())).findFirst().map(EXCEPTION_MAPPING::get).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

