/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.api.exception.handler;

import com.castsoftware.sca.scar.server.api.model.ApiError;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.time.Instant;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class FallbackExceptionHandler {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(FallbackExceptionHandler.class);
    private static final Map<Class<? extends Throwable>, HttpStatus> EXCEPTION_MAPPING = Map.of(IllegalArgumentException.class, HttpStatus.BAD_REQUEST, NoSuchElementException.class, HttpStatus.NOT_FOUND, IllegalAccessError.class, HttpStatus.UNAUTHORIZED, IllegalStateException.class, HttpStatus.INTERNAL_SERVER_ERROR);

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<ApiError> handleFallbackException(@NonNull Throwable throwable) {
        LOGGER.error("Request failed: {}", (Object)Optional.ofNullable(throwable.getMessage()).orElse("Unknown reason"), (Object)throwable);
        HttpStatus httpStatus = Optional.ofNullable(throwable).map(Object::getClass).map(EXCEPTION_MAPPING::get).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
        ApiError apiError = ApiError.builder().status(httpStatus.value()).code("unexpected_error").message("An unexpected error occurred").timestamp(Instant.now()).build();
        return ResponseEntity.status((HttpStatusCode)httpStatus).body((Object)apiError);
    }
}

