/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GitHostUtils {
    private static final Pattern GH_GL_PATTERN = Pattern.compile("(?:github\\.com|gitlab\\.com)/([a-zA-Z0-9_.-]+/[a-zA-Z0-9_.-]+)");

    private GitHostUtils() {
    }

    public static Optional<String> extractGitHubOrGitLabOrgProject(String text) {
        if (text == null || text.isEmpty()) {
            return Optional.empty();
        }
        Matcher matcher = GH_GL_PATTERN.matcher(text);
        if (matcher.find()) {
            String orgAndProject = matcher.group(1);
            if (orgAndProject.endsWith(".git")) {
                orgAndProject = orgAndProject.substring(0, orgAndProject.length() - 4);
            }
            return Optional.of(orgAndProject);
        }
        return Optional.empty();
    }
}

