/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.NodeProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class YarnLockProcessor
extends NodeProcessor {
    public YarnLockProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        String lockFile = this.getBomFolder() + fileNode.getPath();
        AtomicReference<String> previousLine = new AtomicReference<String>("");
        try (BufferedReader br = Files.newBufferedReader(Paths.get(lockFile, new String[0]));){
            br.lines().forEach(line -> {
                if (line.trim().startsWith("version")) {
                    String version = StringUtils.substringBetween((String)line, (String)"\"");
                    String name = StringUtils.substringBeforeLast((String)StringUtils.remove((String)((String)previousLine.get()), (String)"\"").split(",")[0], (String)"@");
                    result.add(Snippet.builder().name(name).scaProject(name + ".npm").scaVersion(version).fromFile(fileNode).build());
                }
                previousLine.set((String)line);
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read yarn lock file or to parse it.");
        }
        if (this.getOptions().isOnlyDirect()) {
            this.filterDirect(result, fileNode);
        }
        return result;
    }
}

