/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.PythonStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.SingleRange;
import com.castsoftware.antepedia.tools.semverTool.internal.LexerException;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.util.GitHostUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequirementsTxtProcessor
extends PackageProcessor {
    private final Parser<Range> rangeParser = PythonStyleRangeParser.instance();

    public RequirementsTxtProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        return this.parseRequirementsFile(new HashSet(), fileNode);
    }

    private List<Snippet> parseRequirementsFile(Set<Path> visitedFiles, FileNode fileNode) {
        String requirementsTxtFile = this.getBomFolder() + fileNode.getPath();
        Path filePath = Paths.get(requirementsTxtFile, new String[0]);
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        if (!visitedFiles.add(filePath.toAbsolutePath())) {
            return result;
        }
        try (BufferedReader br = Files.newBufferedReader(filePath);){
            br.lines().forEach(line -> {
                line = line.trim();
                if ((line = line.split("#", 2)[0].trim()).isEmpty() || line.startsWith("../") || line.startsWith("./")) {
                    return;
                }
                if (line.startsWith("-r ") || line.startsWith("--requirement ")) {
                    String[] parts = line.split("\\s+", 2);
                    if (parts.length == 2) {
                        fileNode.setName(parts[1].trim());
                        result.addAll(this.parseRequirementsFile(visitedFiles, fileNode));
                    }
                    return;
                }
                if (line.startsWith("-e ") || line.startsWith("http://") || line.startsWith("https://") || line.startsWith("git+")) {
                    GitHostUtils.extractGitHubOrGitLabOrgProject((String)line).ifPresent(orgAndProject -> result.add(Snippet.builder().name(orgAndProject).fromFile(fileNode).build()));
                    return;
                }
                line = line.split(";")[0].trim();
                line = line.replaceAll("\\[.*?]", "");
                Matcher matcher = Pattern.compile("^([a-zA-Z0-9_.-]+)(.*)$").matcher((CharSequence)line);
                if (matcher.matches()) {
                    String packageName = matcher.group(1);
                    String version = null;
                    try {
                        Range versionRange = (Range)this.rangeParser.parse(matcher.group(2).trim());
                        if (versionRange instanceof SingleRange && ((SingleRange)versionRange).getRangeType() == Range.SingleType.EQ) {
                            version = versionRange.toString();
                        }
                    }
                    catch (LexerException e) {
                        System.err.println("[WARN] Failed to parse version for package '" + packageName + "' in " + fileNode.getPath() + ": " + e.getMessage());
                    }
                    result.add(Snippet.builder().name(packageName).scaProject(packageName + ".py").scaVersion(version).fromFile(fileNode).build());
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read requirements.txt file or to parse it.");
        }
        return result;
    }
}

