/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.NodeProcessor;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

public class PoetryAndUvProcessor
extends NodeProcessor {
    public PoetryAndUvProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        TomlParseResult tomlParseResult;
        String poetryLockFile = this.getBomFolder() + fileNode.getPath();
        try {
            tomlParseResult = Toml.parse((Path)Paths.get(poetryLockFile, new String[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse " + fileNode.getPath(), e);
        }
        if (tomlParseResult.hasErrors()) {
            tomlParseResult.errors().forEach(error -> System.err.println(error.toString()));
        }
        TomlArray packages = tomlParseResult.getArray("package");
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        if (packages == null) {
            return Collections.emptyList();
        }
        packages.toList().stream().map(obj -> (TomlTable)obj).forEach(pkg -> {
            Snippet snippet = this.toSnippet(pkg, fileNode);
            if (snippet != null) {
                result.add(snippet);
            }
        });
        return result;
    }

    private Snippet toSnippet(TomlTable pkg, FileNode fileNode) {
        if (pkg.getString("name") == null || pkg.getString("version") == null) {
            return null;
        }
        return Snippet.builder().name(pkg.getString("name")).scaProject(pkg.getString("name") + ".py").scaVersion(pkg.getString("version")).fromFile(fileNode).build();
    }
}

