/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.PythonStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.SingleRange;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.NodeProcessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class PipfileLockProcessor
extends NodeProcessor {
    private final Parser<Range> rangeParser = PythonStyleRangeParser.instance();

    public PipfileLockProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        String pipfileLock = this.getBomFolder() + fileNode.getPath();
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        try {
            JsonNode root = mapper.readTree(new File(pipfileLock));
            Optional.ofNullable(root.get("default")).ifPresent(deps -> deps.fieldNames().forEachRemaining(dependencyName -> {
                AtomicReference<Object> versionRef = new AtomicReference<Object>(null);
                Optional.ofNullable(deps.get(dependencyName).get("version")).ifPresent(vNode -> {
                    Range versionRange = (Range)this.rangeParser.parse(deps.get(dependencyName).get("version").asText());
                    if (versionRange instanceof SingleRange && ((SingleRange)versionRange).getRangeType() == Range.SingleType.EQ) {
                        versionRef.set(versionRange.toString());
                    }
                });
                result.add(Snippet.builder().name(dependencyName).scaProject(dependencyName + ".py").scaVersion((String)versionRef.get()).fromFile(fileNode).build());
            }));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse " + pipfileLock);
        }
        return result;
    }
}

