/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.NodeProcessor;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PackageLockProcessor
extends NodeProcessor {
    public PackageLockProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        String lockFile = this.getBomFolder() + fileNode.getPath();
        try {
            JsonNode root = this.getJsonMapper().readTree(new File(lockFile));
            if (root == null || root.isNull()) {
                return result;
            }
            JsonNode packagesNode = root.get("packages");
            if (packagesNode != null && !packagesNode.isNull()) {
                JsonNode rootPackage = packagesNode.get("");
                if (rootPackage != null && !rootPackage.isNull()) {
                    JsonNode deps = rootPackage.get("dependencies");
                    this.collectFromDepsObject(result, packagesNode, deps, fileNode);
                }
            } else {
                JsonNode deps = root.get("dependencies");
                if (deps != null && !deps.isNull()) {
                    deps.fieldNames().forEachRemaining(dependencyName -> {
                        JsonNode depNode = deps.get(dependencyName);
                        if (depNode != null && depNode.has("version")) {
                            String version = depNode.get("version").asText();
                            result.add(this.toSnippet(dependencyName, version, fileNode));
                        }
                    });
                }
            }
            if (this.getOptions().isOnlyDirect()) {
                this.filterDirect(result, fileNode);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read or parse package-lock.json file.", e);
        }
        return result;
    }

    private void collectFromDepsObject(List<Snippet> result, JsonNode packagesNode, JsonNode depsNode, FileNode fileNode) {
        if (depsNode == null || depsNode.isNull()) {
            return;
        }
        depsNode.fieldNames().forEachRemaining(dependencyName -> {
            String pkgKey = "node_modules/" + dependencyName;
            JsonNode pkgNode = packagesNode.get(pkgKey);
            JsonNode sourceNode = pkgNode != null && pkgNode.has("version") ? pkgNode : depsNode.get(dependencyName);
            if (sourceNode != null && sourceNode.has("version")) {
                String version = sourceNode.get("version").asText();
                result.add(this.toSnippet(dependencyName, version, fileNode));
            }
        });
    }

    private Snippet toSnippet(String dependencyName, String version, FileNode fileNode) {
        return Snippet.builder().name(dependencyName).scaProject(dependencyName + ".npm").scaVersion(version).fromFile(fileNode).build();
    }
}

