/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.NpmStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.SingleRange;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.NodeProcessor;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PackageJsonProcessor
extends NodeProcessor {
    private final Parser<Range> rangeParser = NpmStyleRangeParser.instance();

    public PackageJsonProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        String manifestFile = this.getBomFolder() + fileNode.getPath();
        try {
            JsonNode root = this.getJsonMapper().readTree(new File(manifestFile));
            for (String field : new String[]{"dependencies"}) {
                JsonNode deps = root.get(field);
                if (deps == null || !deps.isObject()) continue;
                deps.fields().forEachRemaining(entry -> {
                    String name = (String)entry.getKey();
                    Range versionRange = (Range)this.rangeParser.parse(((JsonNode)entry.getValue()).asText());
                    String version = null;
                    if (versionRange instanceof SingleRange && ((SingleRange)versionRange).getRangeType() == Range.SingleType.EQ) {
                        version = versionRange.toString();
                    }
                    result.add(Snippet.builder().name(name).scaProject(name + ".npm").scaVersion(version).fromFile(fileNode).build());
                });
            }
            if (this.getOptions().isOnlyDirect()) {
                this.filterDirect(result, fileNode);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read package.json or to parse it.");
        }
        return result;
    }
}

