/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.NuGetProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class NuGetProcessor
extends PackageProcessor {
    private static final String NUGET_PACKAGE_EXTENSION = ".NET";

    public NuGetProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        LinkedHashMap unique = new LinkedHashMap();
        String path = FilenameUtils.separatorsToSystem((String)(this.getBomFolder() + fileNode.getPath()));
        if (ProjectFileParser.hasProjectFileExtension((String)fileNode.getName())) {
            Optional projectFileParser = ProjectFileParser.parseProjectFile((String)path);
            projectFileParser.ifPresent(fileParser -> fileParser.getPackageReferences().forEach(pr -> {
                Snippet s = this.createSnippet(pr.getInclude(), pr.getVersion(), fileNode);
                unique.put(pr.getInclude() + "@" + pr.getVersion(), s);
            }));
        } else if ("packages.config".equals(fileNode.getName())) {
            Optional packagesConfigParser = PackagesConfigParser.parsePackagesConfig((String)path);
            packagesConfigParser.ifPresent(configParser -> configParser.getPackages().forEach(p -> {
                Snippet s = this.createSnippet(p.getId(), p.getVersion(), fileNode);
                unique.put(p.getId() + "@" + p.getVersion(), s);
            }));
        } else if ("project.json".equals(fileNode.getName())) {
            Optional projectJsonParser = ProjectJsonParser.parseProjectJson((String)path);
            projectJsonParser.ifPresent(jsonParser -> jsonParser.getDependencies().forEach(d -> {
                Snippet s = this.createSnippet(d.getName(), d.getVersion(), fileNode);
                unique.put(d.getName() + "@" + d.getVersion(), s);
            }));
        }
        return new ArrayList<Snippet>(unique.values());
    }

    private Snippet createSnippet(String name, String version, FileNode fromFile) {
        return Snippet.builder().name(name).scaProject(name + ".NET").scaVersion(version).fromFile(fromFile).build();
    }

    public static Optional<Document> readXmlFileWithIgnoreCase(String xmlUrl) {
        Optional<Document> optional;
        block25: {
            Path requested = Paths.get(xmlUrl, new String[0]);
            Path parent = requested.getParent();
            if (parent == null) {
                return Optional.empty();
            }
            Path targetPath = null;
            if (Files.exists(requested, new LinkOption[0])) {
                targetPath = requested;
            } else if (Files.isDirectory(parent, new LinkOption[0])) {
                String targetName = requested.getFileName().toString();
                try (Stream<Path> stream = Files.list(parent);){
                    targetPath = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().equalsIgnoreCase(targetName)).findFirst().orElse(null);
                }
            }
            if (targetPath == null) {
                return Optional.empty();
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            try {
                dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbFactory.setXIncludeAware(false);
                dbFactory.setExpandEntityReferences(false);
            }
            catch (ParserConfigurationException stream) {
                // empty catch block
            }
            InputStream is = Files.newInputStream(targetPath, new OpenOption[0]);
            try {
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document document = dBuilder.parse(is);
                document.getDocumentElement().normalize();
                optional = Optional.of(document);
                if (is == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        return Optional.empty();
                    }
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    public static String readSlnFile(String fileName, String folderPath) {
        try {
            Path path = Paths.get(folderPath, fileName);
            if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
                return Files.readString(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }
}

