/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.NpmStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.Version;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class NodeProcessor
extends PackageProcessor {
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final Parser<Range> rangeParser = NpmStyleRangeParser.instance();

    public NodeProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    private Map<String, String> readDependencies(JsonNode node, String fieldName) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (node.hasNonNull(fieldName)) {
            node.get(fieldName).fieldNames().forEachRemaining(name -> result.put((String)name, node.get(fieldName).get(name).asText()));
        }
        return result;
    }

    private List<Snippet> filterSnippets(List<Snippet> allSnippets, FileNode mainPackageFile) throws IOException {
        String packageFile = this.getBomFolder() + mainPackageFile.getPath();
        JsonNode mainNode = this.getJsonMapper().readTree(new File(packageFile));
        Map<String, String> deps = Stream.of("dependencies", "devDependencies", "peerDependencies").map(d -> this.readDependencies(mainNode, d)).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return allSnippets.stream().filter(s -> deps.containsKey(s.getName())).filter(s -> ((Range)this.rangeParser.parse((String)deps.get(s.getName()))).satisfyBy(Version.fromString((String)s.getScaVersion()))).collect(Collectors.toList());
    }

    protected ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    protected void filterDirect(List<Snippet> result, FileNode fileNode) {
        fileNode.getParent().getChildren().stream().filter(f -> f.getName().equals("package.json")).findFirst().ifPresent(pj -> {
            try {
                result.retainAll(this.filterSnippets(result, pj));
            }
            catch (IOException ignored) {
                throw new IllegalStateException("Unable to read package.json or to parse it.");
            }
        });
    }
}

