/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.castsoftware.sca.util.java.Suppliers;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.merge.ModelMerger;

public class MavenProcessor
extends PackageProcessor {
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^}]+)}");
    private final String localRepository;

    public MavenProcessor(String bomFolder, PackageOption options, String localRepository) {
        super(bomFolder, options);
        this.localRepository = localRepository;
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        Map models = this.parseModel(fileNode, null);
        models.forEach((key, value) -> this.getDependencies(value).forEach(s -> {
            s.setFromFile(key);
            result.add((Snippet)s);
        }));
        return result;
    }

    private Map<FileNode, Model> parseModel(FileNode fileNode, Model parent) {
        HashMap<FileNode, Model> result = new HashMap<FileNode, Model>();
        Model model = this.getModel(this.getBomFolder() + fileNode.getPath(), fileNode, parent);
        if (model != null) {
            if (model.getPackaging().equals("pom")) {
                for (Object module : model.getModules()) {
                    module = (String)module + (((String)(module = this.replaceVariables((String)module, model, this.getPomProperties(model)))).endsWith(".xml") ? "" : (((String)module).endsWith("/") ? "pom.xml" : "/pom.xml"));
                    String[] subs = ((String)module).split("/");
                    FileNode currentNode = fileNode.getParent();
                    for (String sub : subs) {
                        if (sub.equals(".") || sub.equals("/")) continue;
                        if (sub.equals("..")) {
                            if ((currentNode = currentNode.getParent()) != null) continue;
                            throw new IllegalStateException("submodule defined outside of bom folder");
                        }
                        currentNode = currentNode.getChildren().stream().filter(f -> f.getName().equals(sub)).findFirst().orElseThrow(Suppliers.illegalState((String)("module url not found " + sub)));
                    }
                    result.putAll(this.parseModel(currentNode, model));
                }
            } else {
                result.put(fileNode, model);
            }
        }
        return result;
    }

    private Model getModel(String pomFileUrl, FileNode currentNode, Model parent) {
        Model model = this.readModel(pomFileUrl);
        if (model != null) {
            String parentUrl;
            Map props = this.getPomProperties(model);
            if (parent == null && model.getParent() != null && (parentUrl = this.getParentFileUrl(model, currentNode, props)) != null) {
                parent = this.getModel(parentUrl, currentNode, null);
            }
            if (parent != null) {
                this.mergeInto(model, parent);
                props = this.getPomProperties(model);
            }
            if (model.getDependencyManagement() != null && !model.getDependencyManagement().getDependencies().isEmpty()) {
                List<Dependency> importedDependencies = model.getDependencyManagement().getDependencies().stream().filter(d -> d.getScope() != null && d.getType() != null && d.getScope().equals("import") && d.getType().equals("pom")).toList();
                for (Dependency d2 : importedDependencies) {
                    String pomDepFile;
                    Model depModel;
                    String depGroupId = this.replaceVariables(d2.getGroupId().replace('.', '/'), model, props);
                    String depArtifactId = this.replaceVariables(d2.getArtifactId(), model, props);
                    String depVersion = this.replaceVariables(d2.getVersion(), model, props);
                    if (!this.getOptions().isAllowExternal() || !StringUtils.isNotBlank((CharSequence)this.localRepository) || (depModel = this.getModel(pomDepFile = Paths.get(this.localRepository, depGroupId + "/" + depArtifactId + "/" + depVersion + "/" + depArtifactId + "-" + depVersion + ".pom").toString(), currentNode, null)) == null) continue;
                    model.getProperties().putAll((Map<?, ?>)depModel.getProperties());
                    if (depModel.getDependencyManagement() == null) continue;
                    for (Dependency subDep : depModel.getDependencyManagement().getDependencies()) {
                        model.getDependencyManagement().addDependency(subDep);
                    }
                }
            }
        }
        return model;
    }

    private Model readModel(String pomFileUrl) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = null;
        File pomFile = new File(pomFileUrl);
        try (FileReader fileReader = new FileReader(pomFile);){
            model = reader.read((Reader)fileReader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model;
    }

    private String getParentFileUrl(Model fromModel, FileNode fromNode, Map<String, String> props) {
        Object parentPomUrl;
        String parentGroupId = this.replaceVariables(fromModel.getParent().getGroupId().replace('.', '/'), fromModel, props);
        String parentArtifactId = this.replaceVariables(fromModel.getParent().getArtifactId(), fromModel, props);
        String parentVersion = this.replaceVariables(fromModel.getParent().getVersion(), fromModel, props);
        if (fromNode != null) {
            Model model;
            parentPomUrl = this.getBomFolder() + fromNode.getParent().getPath() + fromModel.getParent().getRelativePath();
            if (!new File((String)parentPomUrl).getAbsolutePath().contains(this.getBomFolder()) && !this.getOptions().isAllowExternal()) {
                parentPomUrl = null;
            }
            if (parentPomUrl != null && (model = this.readModel((String)parentPomUrl)) != null && model.getGroupId().equals(parentGroupId) && model.getArtifactId().equals(parentArtifactId)) {
                return parentPomUrl;
            }
        }
        if (this.getOptions().isAllowExternal() && StringUtils.isNotBlank((CharSequence)this.localRepository) && new File((String)(parentPomUrl = Paths.get(this.localRepository, parentGroupId + "/" + parentArtifactId + "/" + parentVersion + "/" + parentArtifactId + "-" + parentVersion + ".pom").toString())).isFile()) {
            return parentPomUrl;
        }
        return null;
    }

    private void mergeInto(Model current, Model parent) {
        ModelMerger merger = new ModelMerger();
        merger.merge(current, parent, false, null);
    }

    private Map<String, String> getPomProperties(Model model) {
        int hashCode;
        HashMap<String, String> vars = new HashMap<String, String>();
        model.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> vars.put((String)k, (String)v)));
        do {
            hashCode = vars.hashCode();
            vars.keySet().stream().filter(k -> ((String)vars.get(k)).contains("$")).forEach(k -> vars.put((String)k, this.replaceVariables((String)vars.get(k), model, (Map)vars)));
        } while (vars.hashCode() != hashCode);
        return vars;
    }

    private String replaceVariables(String source, Model model, Map<String, String> props) {
        String result = source;
        if (result != null && result.contains("$")) {
            Matcher varMatcher = varPattern.matcher(source);
            while (varMatcher.find()) {
                String key = varMatcher.group(1);
                String replacement = props.get(key);
                if (replacement == null) {
                    if (key.startsWith("project.") || key.startsWith("version") || key.startsWith("pom")) {
                        switch (key) {
                            case "pom.name": 
                            case "project.name": {
                                String string = model.getName();
                                break;
                            }
                            case "version": 
                            case "pom.version": 
                            case "project.version": {
                                String string = model.getVersion();
                                break;
                            }
                            case "project.artifactId": {
                                String string = model.getArtifactId();
                                break;
                            }
                            case "project.groupId": {
                                String string = model.getGroupId();
                                break;
                            }
                            case "project.organization.name": {
                                String string = model.getOrganization().getName();
                                break;
                            }
                            default: {
                                String string = replacement = replacement;
                            }
                        }
                    }
                    if (replacement == null) {
                        replacement = "";
                    }
                }
                result = result.replace(varMatcher.group(0), replacement);
            }
        }
        return result;
    }

    private Set<Snippet> getDependencies(Model model) {
        HashSet<Snippet> result = new HashSet<Snippet>();
        Map properties = this.getPomProperties(model);
        HashMap managedDependencies = new HashMap();
        if (model.getDependencyManagement() != null) {
            model.getDependencyManagement().getDependencies().forEach(dependency -> {
                String name = this.replaceVariables(dependency.getGroupId() + ":" + dependency.getArtifactId(), model, properties);
                String version = this.replaceVariables(dependency.getVersion(), model, properties);
                managedDependencies.put(name, version);
            });
        }
        model.getDependencies().forEach(dependency -> result.add(this.createDependency(dependency, managedDependencies, model, properties)));
        model.getProfiles().stream().filter(p -> p.getActivation() != null && p.getActivation().isActiveByDefault()).forEach(p -> p.getDependencies().forEach(dependency -> result.add(this.createDependency(dependency, managedDependencies, model, properties))));
        return result;
    }

    private Snippet createDependency(Dependency dependency, Map<String, String> managedDependencies, Model model, Map<String, String> properties) {
        String name = this.replaceVariables(dependency.getGroupId() + ":" + dependency.getArtifactId(), model, properties);
        String version = this.replaceVariables(dependency.getVersion(), model, properties);
        if (version == null && managedDependencies.containsKey(name)) {
            version = managedDependencies.get(name);
        }
        return Snippet.builder().name(name).scaProject(name).scaVersion(version).build();
    }
}

