/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.GradleLockProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public class GradleLockProcessor
extends PackageProcessor {
    private static final String CONFIGURATION_UNSPECIFIED = "unspecified";
    private static final Pattern WITH_CONFIGS_EQ_PATTERN = Pattern.compile("^\\s*([A-Za-z0-9_.-]+):([A-Za-z0-9_.-]+):([^=\\s#]+)\\s*=\\s*([^#]+?)(?:\\s*#.*)?\\s*$");
    private static final Pattern TRIPLE_NO_EQ_PATTERN = Pattern.compile("^\\s*([A-Za-z0-9_.-]+):([A-Za-z0-9_.-]+):([^\\s#=]+)(?:\\s*#.*)?\\s*$");

    public GradleLockProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    private SourceKind detectKind(FileNode fileNode) {
        if (fileNode != null && fileNode.isFile() && "gradle.lockfile".equals(fileNode.getName())) {
            return SourceKind.MODERN_SINGLE_LOCKFILE;
        }
        return SourceKind.LEGACY_PER_CONFIGURATION_DIR;
    }

    private Map<String, List<Snippet>> parseModernSingleLockfile(FileNode fileNode) {
        HashMap<String, List<Snippet>> byConfiguration = new HashMap<String, List<Snippet>>();
        File file = new File(this.getBomFolder(), fileNode.getPath());
        byConfiguration.put("unspecified", this.parseSnippetsFromFile(file, fileNode));
        return byConfiguration;
    }

    private Map<String, List<Snippet>> parseLegacyPerConfigurationLockfiles(FileNode fileNode) {
        HashMap<String, List<Snippet>> byConfiguration = new HashMap<String, List<Snippet>>();
        if (fileNode.isFile()) {
            File file = new File(this.getBomFolder(), fileNode.getPath());
            String configuration = GradleLockProcessor.inferConfigurationFromFileName((String)fileNode.getName());
            byConfiguration.put(configuration, this.parseSnippetsFromFile(file, fileNode));
            return byConfiguration;
        }
        fileNode.getChildren().stream().filter(FileNode::isFile).filter(f -> f.getName().endsWith(".lockfile")).forEach(f -> {
            File file = new File(this.getBomFolder(), f.getPath());
            String configuration = GradleLockProcessor.inferConfigurationFromFileName((String)f.getName());
            byConfiguration.put(configuration, this.parseSnippetsFromFile(file, f));
        });
        return byConfiguration;
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        SourceKind kind = this.detectKind(fileNode);
        Map byConfiguration = kind == SourceKind.MODERN_SINGLE_LOCKFILE ? this.parseModernSingleLockfile(fileNode) : this.parseLegacyPerConfigurationLockfiles(fileNode);
        Set requested = this.getOptions() != null ? this.getOptions().getGradleConfigurations() : null;
        LinkedHashMap gaToSnippet = new LinkedHashMap();
        if (requested == null || requested.isEmpty()) {
            byConfiguration.values().forEach(list -> list.forEach(s -> gaToSnippet.putIfAbsent(s.getName(), s)));
        } else {
            List unspecified;
            boolean anyMatched = false;
            for (String configuration : requested) {
                List list2 = (List)byConfiguration.get(configuration);
                if (list2 == null) continue;
                anyMatched = true;
                list2.forEach(s -> gaToSnippet.putIfAbsent(s.getName(), s));
            }
            if (!anyMatched && (unspecified = (List)byConfiguration.get("unspecified")) != null) {
                unspecified.forEach(s -> gaToSnippet.putIfAbsent(s.getName(), s));
            }
        }
        return new ArrayList<Snippet>(gaToSnippet.values());
    }

    private static String removeCommentsAndTrim(String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        int idx = trimmed.indexOf(35);
        if (idx >= 0) {
            trimmed = trimmed.substring(0, idx).trim();
        }
        return trimmed.isEmpty() ? null : trimmed;
    }

    private static String inferConfigurationFromFileName(String name) {
        if (name == null) {
            return "unspecified";
        }
        if ("gradle.lockfile".equals(name)) {
            return "unspecified";
        }
        if (name.endsWith(".lockfile")) {
            return name.substring(0, name.length() - ".lockfile".length());
        }
        return "unspecified";
    }

    private List<Snippet> parseSnippetsFromFile(File file, FileNode from) {
        ArrayList<Snippet> snippets = new ArrayList<Snippet>();
        if (file == null || !file.exists() || !file.isFile()) {
            return snippets;
        }
        try (Stream<String> lines = Files.lines(file.toPath());){
            lines.map(String::trim).filter(l -> !l.isEmpty() && !l.startsWith("#")).map(arg_0 -> this.parseLine(arg_0)).flatMap(Optional::stream).forEach(parts -> {
                String ga = parts[0] + ":" + parts[1];
                snippets.add(Snippet.builder().name(ga).scaProject(ga).scaVersion(GradleLockProcessor.removeCommentsAndTrim((String)parts[2])).fromFile(from).build());
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return snippets;
    }

    private Optional<String[]> parseLine(String line) {
        Matcher m2 = WITH_CONFIGS_EQ_PATTERN.matcher(line);
        if (m2.matches()) {
            return Optional.of(new String[]{m2.group(1), m2.group(2), m2.group(3)});
        }
        Matcher m3 = TRIPLE_NO_EQ_PATTERN.matcher(line);
        if (m3.matches()) {
            return Optional.of(new String[]{m3.group(1), m3.group(2), m3.group(3)});
        }
        return Optional.empty();
    }
}

