/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.GradleBuildProcessor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public class GradleBuildProcessor
extends PackageProcessor {
    private static final Pattern GAV_WHOLE = Pattern.compile("^\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\(?\\s*(['\"])((?:\\\\.|(?!\\2).)*)\\2\\s*\\)?");
    private static final Pattern GAV_WHOLE_TRIPLE = Pattern.compile("^\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\(?\\s*\"\"\"(.*?)\"\"\"\\s*\\)?");
    private static final Pattern GAV_WHOLE_TRIPLE_SINGLE = Pattern.compile("^\\s*([A-Za-z][A-Za-z0-9_]*)\\s*\\(?\\s*'''(.*?)'''\\s*\\)?");
    private static final Pattern CONFIG_AND_ARGS = Pattern.compile("^\\s*([A-Za-z][A-Za-z0-9_]*)\\s*(?:\\((.*)\\)|\\s+(.*))\\s*.*$");
    private static final Pattern PAIR_QUOTED = Pattern.compile("(?i)\\b(group|name|artifact|version)\\s*:\\s*(['\"])((?:\\\\.|(?!\\2).)+?)\\2");
    private static final Pattern PAIR_BARE_IDENT = Pattern.compile("(?i)\\b(group|name|artifact|version)\\s*:\\s*([A-Za-z_][A-Za-z0-9_.-]*|[0-9][0-9A-Za-z._-]*)");
    private static final Pattern EXT_DOT_ASSIGN = Pattern.compile("^\\s*(?:project\\.)?ext\\.([A-Za-z_][A-Za-z0-9_]*)\\s*=\\s*(['\"])\\s*([^'\"]+)\\s*\\2\\s*$");
    private static final Pattern EXT_BRACKET_ASSIGN = Pattern.compile("^\\s*(?:project\\.)?ext\\[(['\"])\\s*([^'\"]+)\\s*\\1]\\s*=\\s*(['\"])\\s*([^'\"]+)\\s*\\3\\s*$");
    private static final Pattern PROJECT_EXT_SET = Pattern.compile("^\\s*(?:project\\.)?ext\\.set\\(\\s*(['\"])\\s*([^'\"]+)\\s*\\1\\s*,\\s*(['\"])\\s*([^'\"]+)\\s*\\3\\s*\\)\\s*$");
    private static final Pattern DEF_ASSIGN = Pattern.compile("^\\s*(?:(?:public|private|protected|static|final|transient|volatile)\\s+)*(?:def|String|var)\\s+([A-Za-z_][A-Za-z0-9_]*)\\s*=\\s*(['\"])\\s*([^'\"]+)\\s*\\2\\s*$");
    private static final Pattern BARE_ASSIGN = Pattern.compile("^\\s*([A-Za-z_][A-Za-z0-9_]*)\\s*=\\s*(['\"])\\s*([^'\"]+)\\s*\\2\\s*$");
    private static final Pattern EXT_MAP_SINGLE_ENTRY = Pattern.compile("^\\s*([A-Za-z_][A-Za-z0-9_]*)\\s*=\\s*\\[\\s*(?:([A-Za-z_][A-Za-z0-9_]*)|(['\"])\\s*([^'\"]+)\\s*\\3)\\s*:\\s*(['\"])\\s*([^'\"]+)\\s*\\5\\s*]\\s*$");
    private static final Pattern EXT_MAP_MULTI = Pattern.compile("^\\s*(?:(?:project\\.)?ext\\.)?([A-Za-z_][A-Za-z0-9_]*)\\s*=\\s*\\[(.*?)]\\s*$");
    private static final Pattern MAP_ENTRY_QUOTED = Pattern.compile("(?:([A-Za-z_][A-Za-z0-9_]*)|(['\"])\\s*([^'\"]+)\\s*\\2)\\s*:\\s*(['\"])\\s*([^'\"]+?)\\s*\\4");
    private static final Pattern VAR_PLACEHOLDER_BRACED = Pattern.compile("\\$\\{([A-Za-z_][A-Za-z0-9_$.]*)}");
    private static final Pattern VAR_PLACEHOLDER_BRACKETED = Pattern.compile("\\$\\{([A-Za-z_][A-Za-z0-9_]*)\\[['\"]([^'\"\\]]+)['\"]]}");
    private static final Pattern VAR_PLACEHOLDER_SIMPLE = Pattern.compile("\\$([A-Za-z_][A-Za-z0-9_]*)");
    private static final Pattern BLOCK_COMMENT_INLINE = Pattern.compile("/\\*.*?\\*/");

    public GradleBuildProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        List<String> rawLines;
        Path path = Paths.get(this.getBomFolder(), fileNode.getPath());
        LinkedHashMap gaToSnippet = new LinkedHashMap();
        Set requestedConfigurations = this.getOptions() != null ? this.getOptions().getGradleConfigurations() : null;
        try {
            rawLines = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return List.of();
        }
        List cleaned = rawLines.stream().map(GradleBuildProcessor::stripComments).collect(Collectors.toList());
        Map vars = GradleBuildProcessor.collectVariables(cleaned);
        cleaned.stream().flatMap(GradleBuildProcessor::extractDependencySegments).map(String::trim).filter(s -> !s.isEmpty()).map(s -> this.parseLine(s, vars)).flatMap(Optional::stream).filter(d -> GradleBuildProcessor.isConfigurationIncluded((String)d.configuration, (Set)requestedConfigurations)).filter(d -> d.group != null && d.artifact != null).forEach(d -> {
            String ga = d.group + ":" + d.artifact;
            gaToSnippet.putIfAbsent(ga, Snippet.builder().name(ga).scaProject(ga).scaVersion(d.version).fromFile(fileNode).build());
        });
        return new ArrayList<Snippet>(gaToSnippet.values());
    }

    private Optional<DepDecl> parseLine(String line, Map<String, String> vars) {
        Optional gav;
        String args0;
        Matcher pre = CONFIG_AND_ARGS.matcher(line);
        if (pre.matches() && (args0 = Optional.ofNullable(pre.group(2)).orElse(pre.group(3))) != null) {
            String lower;
            String t = args0.trim();
            if (!(t.isEmpty() || t.charAt(0) != '\"' && t.charAt(0) != '\'')) {
                t = t.substring(1);
            }
            if ((lower = t.toLowerCase(Locale.ROOT)).startsWith("platform(") || lower.startsWith("enforcedplatform(")) {
                return Optional.empty();
            }
        }
        if ((gav = this.parseGavLine(line, vars)).isPresent()) {
            return gav;
        }
        return this.parseMapLine(line, vars);
    }

    private static Stream<String> extractDependencySegments(String line) {
        if (line == null) {
            return Stream.empty();
        }
        String s = line.trim();
        int dep = s.indexOf("dependencies");
        if (dep >= 0) {
            int lb = s.indexOf(123, dep);
            int rb = s.lastIndexOf(125);
            if (lb >= 0) {
                String inner = rb > lb ? s.substring(lb + 1, rb) : s.substring(lb + 1);
                if ((inner = inner.trim()).isEmpty()) {
                    return Stream.empty();
                }
                return Arrays.stream(inner.split(";")).map(String::trim).filter(t -> !t.isEmpty());
            }
        }
        return Stream.of(line);
    }

    private Optional<DepDecl> parseGavLine(String line, Map<String, String> vars) {
        return this.extractConfAndArg(line).map(ca -> new ConfArg(ca.conf, GradleBuildProcessor.resolveVarPlaceholders((String)ca.arg, (Map)vars))).map(ca -> new ConfArg(ca.conf, GradleBuildProcessor.dropExt((String)ca.arg))).flatMap(ca -> this.parseContentToDep(ca.conf, ca.arg));
    }

    private Optional<ConfArg> extractConfAndArg(String line) {
        Matcher g3 = GAV_WHOLE_TRIPLE.matcher(line);
        if (g3.find()) {
            return Optional.of(new ConfArg(g3.group(1), g3.group(2).trim()));
        }
        Matcher g3s = GAV_WHOLE_TRIPLE_SINGLE.matcher(line);
        if (g3s.find()) {
            return Optional.of(new ConfArg(g3s.group(1), g3s.group(2).trim()));
        }
        Matcher gav = GAV_WHOLE.matcher(line);
        if (!gav.find()) {
            return Optional.empty();
        }
        String conf = gav.group(1);
        String argRaw = gav.group(3).trim();
        char quote = gav.group(2).charAt(0);
        String needle = "\\" + quote;
        String unescaped = argRaw.replace(needle, String.valueOf(quote));
        return Optional.of(new ConfArg(conf, unescaped));
    }

    private static String dropExt(String content) {
        if (content == null) {
            return null;
        }
        int at = content.indexOf(64);
        return at >= 0 ? content.substring(0, at).trim() : content;
    }

    private Optional<DepDecl> parseContentToDep(String conf, String content) {
        String version;
        String artifact;
        String group;
        if (content == null) {
            return Optional.empty();
        }
        int c1 = content.indexOf(58);
        if (c1 < 0) {
            return Optional.empty();
        }
        int c2 = content.indexOf(58, c1 + 1);
        if (c2 < 0) {
            group = content.substring(0, c1).trim();
            artifact = content.substring(c1 + 1).trim();
            version = null;
        } else {
            group = content.substring(0, c1).trim();
            artifact = content.substring(c1 + 1, c2).trim();
            String remainder = content.substring(c2 + 1).trim();
            version = remainder.isEmpty() ? null : GradleBuildProcessor.pureVersionOrFullRemainder((String)remainder);
        }
        if (group.isEmpty() || artifact.isEmpty()) {
            return Optional.empty();
        }
        String v = version != null && version.contains("$") ? null : version;
        return Optional.of(new DepDecl(conf, group, artifact, v));
    }

    private static String pureVersionOrFullRemainder(String remainder) {
        if (remainder.contains("://") || remainder.indexOf(47) >= 0) {
            return remainder;
        }
        int first = remainder.indexOf(58);
        int last = remainder.lastIndexOf(58);
        if (first > 0 && first == last) {
            return remainder.substring(0, first).trim();
        }
        return remainder;
    }

    private Optional<DepDecl> parseMapLine(String line, Map<String, String> vars) {
        Matcher m = CONFIG_AND_ARGS.matcher(line);
        if (m.matches()) {
            int brace;
            String conf = m.group(1);
            String args = Optional.ofNullable(m.group(2)).orElse(m.group(3));
            if (args != null && m.group(2) == null && (brace = GradleBuildProcessor.indexOfFirstUnquotedBrace((String)args)) >= 0) {
                args = args.substring(0, brace).trim();
            }
            if (args != null) {
                String group = null;
                String name = null;
                String version = null;
                Matcher pq = PAIR_QUOTED.matcher(args);
                List quotedMatches = pq.results().collect(Collectors.toList());
                for (MatchResult r : quotedMatches) {
                    String key = r.group(1).toLowerCase(Locale.ROOT);
                    String rawVal = r.group(3).trim();
                    char quoteCh = r.group(2).charAt(0);
                    Pattern bsBeforeQuote = Pattern.compile("(\\\\+)(?=" + Pattern.quote(String.valueOf(quoteCh)) + ")");
                    String unescaped = bsBeforeQuote.matcher(rawVal).replaceAll("\\\\");
                    String val = GradleBuildProcessor.resolveVarPlaceholders((String)unescaped, vars);
                    switch (key) {
                        case "group": {
                            group = val;
                            break;
                        }
                        case "artifact": 
                        case "name": {
                            name = val;
                            break;
                        }
                        case "version": {
                            version = val;
                        }
                    }
                }
                Matcher pb = PAIR_BARE_IDENT.matcher(args);
                List bareMatches = pb.results().collect(Collectors.toList());
                for (MatchResult r : bareMatches) {
                    String key = r.group(1).toLowerCase(Locale.ROOT);
                    String raw = r.group(2).trim();
                    String val = GradleBuildProcessor.resolveVarPlaceholders((String)raw, vars);
                    switch (key) {
                        case "group": {
                            if (group != null) break;
                            group = val;
                            break;
                        }
                        case "artifact": 
                        case "name": {
                            if (name != null) break;
                            name = val;
                            break;
                        }
                        case "version": {
                            if (version != null) break;
                            version = GradleBuildProcessor.trimVersion((String)val);
                            break;
                        }
                    }
                }
                if (group != null && name != null) {
                    if (version != null && version.contains("$")) {
                        version = null;
                    }
                    return Optional.of(new DepDecl(conf, group, name, version));
                }
            }
        }
        return Optional.empty();
    }

    private static Map<String, String> collectVariables(List<String> lines) {
        List<Spec> specs = Arrays.asList(new Spec(EXT_DOT_ASSIGN, 1, 3), new Spec(EXT_BRACKET_ASSIGN, 2, 4), new Spec(PROJECT_EXT_SET, 2, 4), new Spec(DEF_ASSIGN, 1, 3), new Spec(BARE_ASSIGN, 1, 3));
        HashMap<String, String> vars = new HashMap<String, String>();
        lines.stream().map(String::trim).filter(s -> !s.isEmpty()).forEach(s -> {
            Matcher multi = EXT_MAP_MULTI.matcher((CharSequence)s);
            if (multi.find()) {
                String base = multi.group(1);
                String content = multi.group(2);
                Matcher em = MAP_ENTRY_QUOTED.matcher(content);
                em.results().forEach(r -> {
                    String key = r.group(1) != null ? r.group(1) : r.group(3);
                    String val = r.group(5);
                    vars.put(base + "." + key, val);
                });
                return;
            }
            Matcher map = EXT_MAP_SINGLE_ENTRY.matcher((CharSequence)s);
            if (map.find()) {
                String baseName = map.group(1);
                String entryKey = map.group(2) != null ? map.group(2) : map.group(4);
                String entryVal = map.group(6);
                vars.put(baseName + "." + entryKey, entryVal);
                return;
            }
            for (Spec spec : specs) {
                Matcher m = spec.p.matcher((CharSequence)s);
                if (!m.find()) continue;
                vars.put(m.group(spec.keyGroup), m.group(spec.valGroup));
                break;
            }
        });
        return vars;
    }

    private static String resolveVarPlaceholders(String value, Map<String, String> vars) {
        String replaced;
        if (value == null) {
            return null;
        }
        boolean hadBraced = VAR_PLACEHOLDER_BRACED.matcher(value).find();
        String stage1 = VAR_PLACEHOLDER_BRACED.matcher(value).replaceAll(mr -> Matcher.quoteReplacement(vars.getOrDefault(mr.group(1), mr.group())));
        boolean hadBracketed = VAR_PLACEHOLDER_BRACKETED.matcher(stage1).find();
        String stage1b = VAR_PLACEHOLDER_BRACKETED.matcher(stage1).replaceAll(mr -> {
            String base = mr.group(1);
            String key = mr.group(2);
            String full = base + "." + key;
            return Matcher.quoteReplacement(vars.getOrDefault(full, mr.group()));
        });
        String stage2 = VAR_PLACEHOLDER_SIMPLE.matcher(stage1b).replaceAll(mr -> {
            String key = mr.group(1);
            return Matcher.quoteReplacement(vars.getOrDefault(key, mr.group()));
        });
        boolean changed2 = hadBracketed || !stage2.equals(stage1b);
        String string = replaced = hadBraced || changed2 ? stage2 : value;
        if (!hadBraced && !changed2 && vars.containsKey(replaced)) {
            return vars.get(replaced);
        }
        return replaced;
    }

    private static String trimVersion(String v) {
        if (v == null) {
            return null;
        }
        String t = v.trim();
        if (t.isEmpty()) {
            return null;
        }
        return (t = t.replaceFirst("[),;\\s]+$", "")).isEmpty() ? null : t;
    }

    private static int indexOfFirstUnquotedBrace(String s) {
        boolean inSingle = false;
        boolean inDouble = false;
        boolean esc = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (esc) {
                esc = false;
                continue;
            }
            if ((inSingle || inDouble) && ch == '\\') {
                esc = true;
                continue;
            }
            if (ch == '\'' && !inDouble) {
                inSingle = !inSingle;
                continue;
            }
            if (ch == '\"' && !inSingle) {
                inDouble = !inDouble;
                continue;
            }
            if (ch != '{' || inSingle || inDouble) continue;
            return i;
        }
        return -1;
    }

    private static String stripComments(String src) {
        if (src == null || src.isEmpty()) {
            return src;
        }
        String line = BLOCK_COMMENT_INLINE.matcher(src).replaceAll("");
        StringBuilder result = new StringBuilder(line.length());
        boolean insideSingleQuotes = false;
        boolean insideDoubleQuotes = false;
        boolean insideTripleDouble = false;
        boolean insideTripleSingle = false;
        char[] chars = line.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (!insideSingleQuotes && !insideDoubleQuotes && !insideTripleDouble && !insideTripleSingle && ch == '/' && i + 1 < chars.length && chars[i + 1] == '/') break;
            if (!insideSingleQuotes && !insideTripleSingle) {
                if (!insideTripleDouble && i + 2 < chars.length && chars[i] == '\"' && chars[i + 1] == '\"' && chars[i + 2] == '\"') {
                    insideTripleDouble = true;
                    result.append('\"').append('\"').append('\"');
                    i += 2;
                    continue;
                }
                if (insideTripleDouble && i + 2 < chars.length && chars[i] == '\"' && chars[i + 1] == '\"' && chars[i + 2] == '\"') {
                    insideTripleDouble = false;
                    result.append('\"').append('\"').append('\"');
                    i += 2;
                    continue;
                }
            }
            if (!insideDoubleQuotes && !insideTripleDouble) {
                if (!insideTripleSingle && i + 2 < chars.length && chars[i] == '\'' && chars[i + 1] == '\'' && chars[i + 2] == '\'') {
                    insideTripleSingle = true;
                    result.append('\'').append('\'').append('\'');
                    i += 2;
                    continue;
                }
                if (insideTripleSingle && i + 2 < chars.length && chars[i] == '\'' && chars[i + 1] == '\'' && chars[i + 2] == '\'') {
                    insideTripleSingle = false;
                    result.append('\'').append('\'').append('\'');
                    i += 2;
                    continue;
                }
            }
            if (insideTripleDouble || insideTripleSingle) {
                result.append(ch);
                continue;
            }
            if (ch == '\\' && (insideDoubleQuotes || insideSingleQuotes) && i + 1 < chars.length) {
                result.append(ch).append(chars[i + 1]);
                ++i;
                continue;
            }
            if (ch == '\'' && !insideDoubleQuotes) {
                insideSingleQuotes = !insideSingleQuotes;
                result.append(ch);
                continue;
            }
            if (ch == '\"' && !insideSingleQuotes) {
                insideDoubleQuotes = !insideDoubleQuotes;
                result.append(ch);
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    private static boolean isConfigurationIncluded(String configuration, Set<String> requestedConfigurations) {
        if (requestedConfigurations == null || requestedConfigurations.isEmpty()) {
            return true;
        }
        return requestedConfigurations.contains(configuration);
    }
}

