/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.RubyStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.SingleRange;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public class GemfileProcessor
extends PackageProcessor {
    private static final Pattern GEM_DECL_PATTERN = Pattern.compile("(?i)\\bgem\\s*\\(?\\s*(['\"])\\s*([A-Za-z0-9_.-]+)\\s*\\1(.*)");
    private static final Pattern QUOTED_TOKEN = Pattern.compile("(['\"])\\s*([^'\"]+?)\\s*\\1");
    private static final Pattern LOOKS_LIKE_VERSION = Pattern.compile("^(?:~>|>=|<=|==|=|!=|>|<)?\\s*[0-9][0-9A-Za-z._-]*$");
    private static final Pattern GIT_HTTP_URL = Pattern.compile("https?://(?:www\\.)?(?:github|gitlab)\\.com/([A-Za-z0-9_.-]+/[A-Za-z0-9_.-]+)(?:\\.git)?(?:/.*)?", 2);
    private static final Pattern GIT_SSH_URL = Pattern.compile("git@(?:github|gitlab)\\.com:([A-Za-z0-9_.-]+/[A-Za-z0-9_.-]+)(?:\\.git)?(?:/.*)?", 2);
    private final Parser<Range> rangeParser = RubyStyleRangeParser.instance();

    public GemfileProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        Path path = Paths.get(this.getBomFolder(), fileNode.getPath());
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        try (BufferedReader br = Files.newBufferedReader(path);){
            br.lines().map(GemfileProcessor::stripComments).map(String::trim).filter(s -> !s.isEmpty()).forEach(trimmed -> GEM_DECL_PATTERN.matcher((CharSequence)trimmed).results().findFirst().ifPresent(mr -> {
                String gemName = mr.group(2);
                String tail = Optional.ofNullable(mr.group(3)).orElse("");
                String orgRepo = GemfileProcessor.extractOrgRepoFromTail((String)tail);
                if (orgRepo != null && !orgRepo.isEmpty()) {
                    gemName = orgRepo;
                }
                List constraintParts = QUOTED_TOKEN.matcher(tail).results().map(r -> r.group(2).trim()).filter(token -> LOOKS_LIKE_VERSION.matcher((CharSequence)token).matches()).collect(Collectors.toList());
                String version = null;
                if (!constraintParts.isEmpty()) {
                    String combined = String.join((CharSequence)",", constraintParts);
                    try {
                        Range parsed = (Range)this.rangeParser.parse(combined);
                        if (parsed instanceof SingleRange && ((SingleRange)parsed).getRangeType() == Range.SingleType.EQ) {
                            version = parsed.toString();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                result.add(Snippet.builder().name(gemName).scaProject(gemName + ".rb").scaVersion(version).fromFile(fileNode).build());
            }));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read Gemfile or to parse it.");
        }
        return result;
    }

    private static String extractOrgRepoFromTail(String tail) {
        if (tail == null || tail.isEmpty()) {
            return null;
        }
        return QUOTED_TOKEN.matcher(tail).results().map(r -> r.group(2).trim()).map(GemfileProcessor::extractOrgRepoFromUrl).filter(s -> s != null && !s.isEmpty()).findFirst().orElse(null);
    }

    private static String extractOrgRepoFromUrl(String url) {
        if (url == null) {
            return null;
        }
        return Stream.of(GIT_HTTP_URL, GIT_SSH_URL).map(pattern -> pattern.matcher(url)).filter(Matcher::matches).map(m -> m.group(1)).findFirst().map(candidate -> candidate.endsWith(".git") ? candidate.substring(0, candidate.length() - 4) : candidate).orElse(null);
    }

    private static String stripComments(String src) {
        return src.replaceAll("(\"[^\"]*\"|'[^']*')|#.*$", "$1");
    }
}

