/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.RubyStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.SingleRange;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class GemfileLockProcessor
extends PackageProcessor {
    private static final Pattern GEM_LINE_PATTERN = Pattern.compile("^\\s*([A-Za-z0-9_.-]+) \\(([^)]+)\\)\\s*$");
    private final Parser<Range> rangeParser = RubyStyleRangeParser.instance();

    public GemfileLockProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        Path path = Paths.get(this.getBomFolder(), fileNode.getPath());
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        boolean inSpecs = false;
        int specsIndent = -1;
        try (BufferedReader br = Files.newBufferedReader(path);){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m;
                int leadingSpaces = GemfileLockProcessor.countLeadingSpaces((String)line);
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                if (trimmed.equals("specs:")) {
                    inSpecs = true;
                    specsIndent = leadingSpaces;
                    continue;
                }
                if (inSpecs && (leadingSpaces <= specsIndent || !line.startsWith(" "))) {
                    inSpecs = false;
                }
                if (!inSpecs || leadingSpaces != specsIndent + 2 || !(m = GEM_LINE_PATTERN.matcher(line)).matches()) continue;
                String gemName = m.group(1);
                String versionRaw = m.group(2);
                String version = null;
                try {
                    Range parsed = (Range)this.rangeParser.parse(versionRaw);
                    if (parsed instanceof SingleRange && ((SingleRange)parsed).getRangeType() == Range.SingleType.EQ) {
                        version = parsed.toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result.add(Snippet.builder().name(gemName).scaProject(gemName + ".rb").scaVersion(version).fromFile(fileNode).build());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read Gemfile.lock file or to parse it.");
        }
        return result;
    }

    private static int countLeadingSpaces(String s) {
        return s.length() - s.stripLeading().length();
    }
}

