/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.ComposerStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.SingleRange;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ComposerProcessor
extends PackageProcessor {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Parser<Range> rangeParser = ComposerStyleRangeParser.instance();

    public ComposerProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        String jsonPath = this.getBomFolder() + fileNode.getPath();
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        try {
            JsonNode root = this.mapper.readTree(new File(jsonPath));
            this.parseRequireMap(root.get("require"), fileNode, result);
            this.parseRequireMap(root.get("require-dev"), fileNode, result);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read composer.json file or to parse it.");
        }
        return result;
    }

    private void parseRequireMap(JsonNode mapNode, FileNode fileNode, List<Snippet> out) {
        Optional.ofNullable(mapNode).ifPresent(obj -> {
            if (obj.isObject()) {
                Iterator fields = obj.fields();
                while (fields.hasNext()) {
                    Map.Entry e = (Map.Entry)fields.next();
                    String name = (String)e.getKey();
                    if (name == null || name.isEmpty() || "php".equalsIgnoreCase(name) || name.startsWith("ext-") || name.startsWith("lib-")) continue;
                    String versionStr = Optional.ofNullable((JsonNode)e.getValue()).map(JsonNode::asText).orElse(null);
                    String version = null;
                    if (versionStr != null && !versionStr.isEmpty()) {
                        try {
                            Range parsed = (Range)this.rangeParser.parse(versionStr);
                            if (parsed instanceof SingleRange && ((SingleRange)parsed).getRangeType() == Range.SingleType.EQ) {
                                version = parsed.toString();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    out.add(Snippet.builder().name(name).scaProject(name + ".php").scaVersion(version).fromFile(fileNode).build());
                }
            }
        });
    }
}

