/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.antepedia.tools.semverTool.ComposerStyleRangeParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Range;
import com.castsoftware.antepedia.tools.semverTool.expression.SingleRange;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ComposerLockProcessor
extends PackageProcessor {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Parser<Range> rangeParser = ComposerStyleRangeParser.instance();

    public ComposerLockProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        String lockPath = this.getBomFolder() + fileNode.getPath();
        ArrayList<Snippet> result = new ArrayList<Snippet>();
        try {
            JsonNode root = this.mapper.readTree(new File(lockPath));
            this.parsePackagesArray(root.get("packages"), fileNode, result);
            this.parsePackagesArray(root.get("packages-dev"), fileNode, result);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read composer.lock file or to parse it.");
        }
        return result;
    }

    private void parsePackagesArray(JsonNode arrayNode, FileNode fileNode, List<Snippet> out) {
        Optional.ofNullable(arrayNode).ifPresent(arr -> {
            if (arr.isArray()) {
                arr.forEach(pkg -> {
                    String name = Optional.ofNullable(pkg.get("name")).map(JsonNode::asText).orElse(null);
                    if (name == null || name.isEmpty()) {
                        return;
                    }
                    String versionStr = Optional.ofNullable(pkg.get("version")).map(JsonNode::asText).orElse(null);
                    String version = null;
                    if (versionStr != null && !versionStr.isEmpty()) {
                        try {
                            Range parsed = (Range)this.rangeParser.parse(versionStr);
                            if (parsed instanceof SingleRange && ((SingleRange)parsed).getRangeType() == Range.SingleType.EQ) {
                                version = parsed.toString();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    out.add(Snippet.builder().name(name).scaProject(name + ".php").scaVersion(version).fromFile(fileNode).build());
                });
            }
        });
    }
}

