/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.util.GitHostUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

/*
 * Exception performing whole class analysis ignored.
 */
public class CargoTomlProcessor
extends PackageProcessor {
    public CargoTomlProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        TomlParseResult toml;
        Path path = Paths.get(this.getBomFolder(), fileNode.getPath());
        try {
            toml = Toml.parse((Path)path);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Failed to read " + fileNode.getPath(), e2);
        }
        if (toml.hasErrors()) {
            boolean hasUsable;
            String msg = toml.errors().stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
            boolean bl = hasUsable = CargoTomlProcessor.hasNonEmptyTable((TomlTable)toml, (String)"dependencies") || CargoTomlProcessor.hasNonEmptyTable((TomlTable)toml, (String)"dev-dependencies") || CargoTomlProcessor.hasNonEmptyTable((TomlTable)toml, (String)"build-dependencies") || CargoTomlProcessor.hasAnyTargetDeps((TomlTable)toml) || CargoTomlProcessor.hasWorkspaceDeps((TomlTable)toml);
            if (!hasUsable) {
                throw new IllegalStateException("Cargo.toml has parse errors and no usable dependency tables:\n" + msg);
            }
            System.err.println("[WARN] Cargo.toml parsed with errors; proceeding best-effort:\n" + msg);
        }
        LinkedHashMap deps = new LinkedHashMap();
        CargoTomlProcessor.streamDepsFromTable((TomlTable)toml, (String)"dependencies").forEach(e -> deps.putIfAbsent((String)e.getKey(), (String)e.getValue()));
        CargoTomlProcessor.streamDepsFromTable((TomlTable)toml, (String)"dev-dependencies").forEach(e -> deps.putIfAbsent((String)e.getKey(), (String)e.getValue()));
        CargoTomlProcessor.streamDepsFromTable((TomlTable)toml, (String)"build-dependencies").forEach(e -> deps.putIfAbsent((String)e.getKey(), (String)e.getValue()));
        Optional.ofNullable(toml.getTable("target")).stream().flatMap(t -> t.keySet().stream().map(arg_0 -> ((TomlTable)t).get(arg_0)).filter(TomlTable.class::isInstance).map(TomlTable.class::cast)).flatMap(tt -> CargoTomlProcessor.streamDepsFromTable((TomlTable)tt, (String)"dependencies")).forEach(e -> deps.putIfAbsent((String)e.getKey(), (String)e.getValue()));
        Optional.ofNullable(toml.getTable("workspace")).flatMap(ws -> Optional.ofNullable(ws.getTable("dependencies"))).ifPresent(wsDeps -> CargoTomlProcessor.streamDepsFromTable((TomlTable)wsDeps).forEach(e -> deps.putIfAbsent((String)e.getKey(), (String)e.getValue())));
        return deps.entrySet().stream().filter(e -> e.getKey() != null && !((String)e.getKey()).isBlank()).map(e -> Snippet.builder().name((String)e.getKey()).scaProject((String)e.getKey() + ".rs").scaVersion((String)e.getValue()).fromFile(fileNode).build()).collect(Collectors.toList());
    }

    private static Stream<Map.Entry<String, String>> streamDepsFromTable(TomlTable root, String tableName) {
        TomlTable table = root.getTable(tableName);
        return CargoTomlProcessor.streamDepsFromTable((TomlTable)table);
    }

    private static Stream<Map.Entry<String, String>> streamDepsFromTable(TomlTable table) {
        if (table == null) {
            return Stream.empty();
        }
        return table.keySet().stream().flatMap(key -> {
            Object val = table.get(key);
            if (val instanceof String) {
                String vStr = (String)val;
                String version = vStr.trim();
                return version.isEmpty() ? Stream.empty() : Stream.of(Map.entry(key, version));
            }
            if (val instanceof TomlTable) {
                TomlTable inline = (TomlTable)val;
                String gitUrl = inline.getString("git");
                String pathUrl = inline.getString("path");
                Optional orgRepo = GitHostUtils.extractGitHubOrGitLabOrgProject((String)(gitUrl != null ? gitUrl : pathUrl));
                if (orgRepo.isPresent() && !((String)orgRepo.get()).isBlank()) {
                    return Stream.of(new AbstractMap.SimpleImmutableEntry<String, Object>((String)orgRepo.get(), null));
                }
                String name = Optional.ofNullable(inline.getString("package")).map(String::trim).filter(s -> !s.isBlank()).orElse((String)key);
                String version = Optional.ofNullable(inline.getString("version")).map(String::trim).filter(s -> !s.isEmpty()).orElse(null);
                return version != null && !name.isBlank() ? Stream.of(Map.entry(name, version)) : Stream.empty();
            }
            return Stream.empty();
        });
    }

    private static boolean hasNonEmptyTable(TomlTable root, String name) {
        TomlTable t = root.getTable(name);
        return t != null && !t.keySet().isEmpty();
    }

    private static boolean hasAnyTargetDeps(TomlTable root) {
        TomlTable target = root.getTable("target");
        if (target == null) {
            return false;
        }
        return target.keySet().stream().map(arg_0 -> ((TomlTable)target).get(arg_0)).filter(TomlTable.class::isInstance).map(TomlTable.class::cast).anyMatch(tt -> {
            TomlTable deps = tt.getTable("dependencies");
            return deps != null && !deps.keySet().isEmpty();
        });
    }

    private static boolean hasWorkspaceDeps(TomlTable root) {
        TomlTable ws = root.getTable("workspace");
        if (ws == null) {
            return false;
        }
        TomlTable deps = ws.getTable("dependencies");
        return deps != null && !deps.keySet().isEmpty();
    }
}

