/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools.processors;

import com.castsoftware.sca.scar.server.analyzer.scanner.options.PackageOption;
import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.tools.PackageProcessor;
import com.castsoftware.sca.scar.server.analyzer.tools.processors.util.GitHostUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

/*
 * Exception performing whole class analysis ignored.
 */
public class CargoLockProcessor
extends PackageProcessor {
    private static final String PKG_TABLE = "package";

    public CargoLockProcessor(String bomFolder, PackageOption options) {
        super(bomFolder, options);
    }

    public List<Snippet> getSnippets(FileNode fileNode) {
        TomlArray pkgs;
        Integer lockfileVersion;
        TomlParseResult toml;
        Path path = Paths.get(this.getBomFolder(), fileNode.getPath());
        try {
            toml = Toml.parse((Path)path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + fileNode.getPath(), e);
        }
        if (toml.hasErrors()) {
            String msg = toml.errors().stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
            if (!CargoLockProcessor.hasAnyPackageArray((TomlParseResult)toml)) {
                throw new IllegalStateException("Cargo.lock has parse errors and no usable [[package]] entries:\n" + msg);
            }
            System.err.println("[WARN] Cargo.lock parsed with errors; proceeding best-effort:\n" + msg);
        }
        if ((lockfileVersion = CargoLockProcessor.getLockfileVersion((TomlParseResult)toml)) != null && lockfileVersion < 3) {
            System.err.println("[WARN] Cargo.lock version=" + lockfileVersion + " (older format). Proceeding.");
        }
        if ((pkgs = toml.getArray("package")) == null || pkgs.isEmpty()) {
            return List.of();
        }
        HashSet seen = new HashSet();
        ArrayList<Snippet> out = new ArrayList<Snippet>(pkgs.size());
        IntStream.range(0, pkgs.size()).mapToObj(arg_0 -> ((TomlArray)pkgs).get(arg_0)).filter(TomlTable.class::isInstance).map(TomlTable.class::cast).map(p -> this.toSnippetIfExternal(p, fileNode)).filter(Objects::nonNull).forEach(s -> {
            String key = s.getName() + "::" + s.getScaVersion() + "::" + s.getFromFile().getPath();
            if (seen.add(key)) {
                out.add((Snippet)s);
            }
        });
        return out;
    }

    private Snippet toSnippetIfExternal(TomlTable p, FileNode fromFile) {
        String crateName = CargoLockProcessor.trimToNull((String)CargoLockProcessor.asString((Object)p.get("name")));
        String version = CargoLockProcessor.trimToNull((String)CargoLockProcessor.asString((Object)p.get("version")));
        String source = CargoLockProcessor.trimToNull((String)CargoLockProcessor.asString((Object)p.get("source")));
        if (crateName == null || version == null) {
            return null;
        }
        if (source == null) {
            return null;
        }
        String effectiveName = this.computeEffectiveName(crateName, source);
        return Snippet.builder().name(effectiveName).scaProject(effectiveName + ".rs").scaVersion(version).fromFile(fromFile).build();
    }

    private String computeEffectiveName(String crateName, String source) {
        if (!source.startsWith("git+")) {
            return crateName;
        }
        String normalized = CargoLockProcessor.stripGitScheme((String)source);
        return GitHostUtils.extractGitHubOrGitLabOrgProject((String)normalized).filter(s -> !s.isBlank()).orElse(crateName);
    }

    private static String asString(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof CharSequence) {
            CharSequence cs = (CharSequence)v;
            String s = cs.toString().trim();
            return s.isEmpty() ? null : s;
        }
        String s = v.toString().trim();
        return s.isEmpty() ? null : s;
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        return t.isEmpty() ? null : t;
    }

    private static boolean hasAnyPackageArray(TomlParseResult toml) {
        TomlArray pkgs = toml.getArray("package");
        return pkgs != null && !pkgs.isEmpty();
    }

    private static Integer getLockfileVersion(TomlParseResult toml) {
        Long v = toml.getLong("version");
        return v == null ? null : Integer.valueOf(v.intValue());
    }

    private static String stripGitScheme(String source) {
        if (source == null) {
            return null;
        }
        return source.startsWith("git+") ? source.substring(4) : source;
    }
}

