/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools;

import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProject;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProjectMetric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;

public class ScaFilters {
    static final int MIN_GIT_REPO_STARS = 100;
    static final List<String> extensions_one = new ArrayList<String>(Arrays.asList("jar", "zip", "tar.gz", "tar", "tgz", "nupkg", "whl", "egg", "aar", "gem", "js", "dll"));
    static final List<String> path_common = new ArrayList<String>(Arrays.asList("test", "docs", "jquery", "example", "plugins", "css", "html"));

    public static boolean filterGitStars(Component component, ScaProject projectData) {
        Optional<ScaProjectMetric> starMetric = projectData.getMetrics().stream().filter(m -> m.getKey().equals("stars")).findFirst();
        return projectData.getRepositoryType().equals("GIT") && (!starMetric.isPresent() || starMetric.get().getValue() < 100);
    }

    public static boolean filterOneFile(Component component, ScaProject projectData) {
        return component.getFiles().size() == 1 && !extensions_one.contains(FilenameUtils.getExtension((String)((FileElement)component.getFiles().get(0)).getFileNode().getName().toLowerCase()));
    }

    public static boolean filterCommonPaths(Component component, ScaProject projectData) {
        return component.getFiles().stream().allMatch(f -> path_common.stream().anyMatch(f.getFileNode().getPath().toLowerCase()::contains));
    }
}

