/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.tools;

import com.castsoftware.sca.scar.server.analyzer.tools.ParsedFileData;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileParsingTool {
    private static final Pattern CLEAN_TEXT = Pattern.compile("\"|'|\\+|(\\*[/)]|-->)");

    public static ParsedFileData parseFile(File file) throws IOException {
        ParsedFileData result = new ParsedFileData();
        try (FileInputStream inputStream = FileUtils.openInputStream((File)file);){
            ByteArrayOutputStream baos = FileParsingTool.getDublicableInputStream((InputStream)inputStream);
            FileParsingTool.getHashData((InputStream)new ByteArrayInputStream(baos.toByteArray()), (ParsedFileData)result);
            FileParsingTool.extractCopyrights((InputStream)new ByteArrayInputStream(baos.toByteArray()), (ParsedFileData)result);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return result;
    }

    public static String cleanCopyright(String input) {
        return input.replaceAll("(?i)copyright|\\([cC\u00a9]\\)|\u00a9", "").replaceAll("\\s{2,}", " ").trim();
    }

    private static ByteArrayOutputStream getDublicableInputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        inputStream.close();
        return baos;
    }

    private static void getHashData(InputStream inputStream, ParsedFileData result) throws NoSuchAlgorithmException, IOException {
        int length;
        MessageDigest digestSha1 = MessageDigest.getInstance("SHA-1");
        MessageDigest digestSha256 = MessageDigest.getInstance("SHA-256");
        MessageDigest digestMd5 = MessageDigest.getInstance("MD5");
        byte[] buffer = new byte[0x100000];
        while ((length = inputStream.read(buffer)) != -1) {
            byte[] newBuffer = FileParsingTool.removeCRFromArray((byte[])buffer, (int)length);
            length = Array.getLength(newBuffer);
            digestSha1.update(newBuffer, 0, length);
            digestSha256.update(newBuffer, 0, length);
            digestMd5.update(newBuffer, 0, length);
        }
        result.setSha1(new String(Hex.encodeHex((byte[])digestSha1.digest())));
        result.setSha256(new String(Hex.encodeHex((byte[])digestSha256.digest())));
        result.setMd5(new String(Hex.encodeHex((byte[])digestMd5.digest())));
    }

    private static void extractCopyrights(InputStream inputstream, ParsedFileData result) {
        Set<Object> res = new LinkedHashSet();
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputstream));){
            res = buffer.lines().filter(l -> l.length() > 15 && l.length() < 200).filter(l -> l.matches(".*((?i)copyright)\\s+(((\\([cC\u00a9]\\))|\u00a9)\\s+)?(((\\d{4}(\\s|,|-))|(\\w{2,}.*\\d{4})).*)")).map(FileParsingTool::cleanText).filter(Objects::nonNull).map(FileParsingTool::cleanCopyright).map(FileParsingTool::cutText).collect(Collectors.toSet());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!res.isEmpty()) {
            result.setCopyrights(String.join((CharSequence)"\n", res));
        }
    }

    private static String cleanText(String text) {
        String s = CLEAN_TEXT.matcher(text).replaceAll("");
        return s.isEmpty() || !s.toLowerCase().contains("copyright") ? null : s.substring(s.toLowerCase().indexOf("copyright")).trim();
    }

    private static String cutText(String text) {
        return text.length() < 128 ? text.trim() : text.substring(0, 127).trim();
    }

    private static byte[] removeCRFromArray(byte[] array, int length) {
        byte[] copy = Arrays.copyOf(array, length);
        return ArrayUtils.removeAllOccurrences((byte[])copy, (byte)13);
    }
}

