/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.structure;

import com.castsoftware.sca.scar.server.analyzer.structure.Vulnerability;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaVulnerability;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityType;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.scar.server.vulnerability.handler.SeverityComputer;
import com.castsoftware.sca.util.java.Opt;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class Vulnerability {
    private String vId;
    private String severity;
    private String description;
    private Long published;
    private List<String> references;
    private List<String> cwes;
    private String cvss2;
    private String cvss3;
    private String score2;
    private String score3;

    public static Vulnerability fromScaVulnerability(ScaVulnerability scaVulnerability) {
        return Vulnerability.builder().vId(scaVulnerability.getName()).description(scaVulnerability.getDescription()).published(scaVulnerability.getPublished()).references(scaVulnerability.getReferences()).cwes(scaVulnerability.getCwes()).cvss2(scaVulnerability.getCvss2()).cvss3(scaVulnerability.getCvss3()).score2(scaVulnerability.getScore2()).score3(scaVulnerability.getScore3()).build();
    }

    public static @NonNull VulnerabilityVertex toVertex(@NonNull Vulnerability vulnerability) {
        VulnerabilityVertex vertex = new VulnerabilityVertex(vulnerability.getVId());
        vertex.setType(vulnerability.getVId().startsWith("CVE") ? VulnerabilityType.CVE.name() : VulnerabilityType.UNDEFINED.name());
        Fields.field((String)vulnerability.getDescription(), arg_0 -> ((VulnerabilityVertex)vertex).setDescription(arg_0));
        Fields.field((Object)vulnerability.getPublished(), ts -> vertex.setPublished(Instant.ofEpochMilli(ts)));
        Fields.field((Collection)vulnerability.getReferences(), arg_0 -> ((VulnerabilityVertex)vertex).setReferences(arg_0));
        Fields.field((Collection)vulnerability.getCwes(), arg_0 -> ((VulnerabilityVertex)vertex).setCwes(arg_0));
        Fields.field((String)vulnerability.getCvss2(), arg_0 -> ((VulnerabilityVertex)vertex).setVector2(arg_0));
        Fields.field((String)vulnerability.getCvss3(), arg_0 -> ((VulnerabilityVertex)vertex).setVector3(arg_0));
        Opt.ofBlankString((String)vulnerability.getScore2()).flatMap(s -> Opt.of((Object)SeverityComputer.severityStringToMapConverter((String)s))).ifPresent(arg_0 -> ((VulnerabilityVertex)vertex).setScores2(arg_0));
        Opt.ofBlankString((String)vulnerability.getScore3()).flatMap(s -> Opt.of((Object)SeverityComputer.severityStringToMapConverter((String)s))).ifPresent(arg_0 -> ((VulnerabilityVertex)vertex).setScores3(arg_0));
        vertex.setSeverity(VulnerabilityType.CVE.name().equals(vertex.getType()) ? SeverityComputer.computeCVESeverity((VulnerabilityVertex)vertex).name() : VulnerabilityLevel.UNKNOWN.name());
        return vertex;
    }

    @Generated
    Vulnerability(String vId, String severity, String description, Long published, List<String> references, List<String> cwes, String cvss2, String cvss3, String score2, String score3) {
        this.vId = vId;
        this.severity = severity;
        this.description = description;
        this.published = published;
        this.references = references;
        this.cwes = cwes;
        this.cvss2 = cvss2;
        this.cvss3 = cvss3;
        this.score2 = score2;
        this.score3 = score3;
    }

    @Generated
    public static VulnerabilityBuilder builder() {
        return new VulnerabilityBuilder();
    }

    @Generated
    public String getVId() {
        return this.vId;
    }

    @Generated
    public String getSeverity() {
        return this.severity;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Long getPublished() {
        return this.published;
    }

    @Generated
    public List<String> getReferences() {
        return this.references;
    }

    @Generated
    public List<String> getCwes() {
        return this.cwes;
    }

    @Generated
    public String getCvss2() {
        return this.cvss2;
    }

    @Generated
    public String getCvss3() {
        return this.cvss3;
    }

    @Generated
    public String getScore2() {
        return this.score2;
    }

    @Generated
    public String getScore3() {
        return this.score3;
    }

    @Generated
    public void setVId(String vId) {
        this.vId = vId;
    }

    @Generated
    public void setSeverity(String severity) {
        this.severity = severity;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPublished(Long published) {
        this.published = published;
    }

    @Generated
    public void setReferences(List<String> references) {
        this.references = references;
    }

    @Generated
    public void setCwes(List<String> cwes) {
        this.cwes = cwes;
    }

    @Generated
    public void setCvss2(String cvss2) {
        this.cvss2 = cvss2;
    }

    @Generated
    public void setCvss3(String cvss3) {
        this.cvss3 = cvss3;
    }

    @Generated
    public void setScore2(String score2) {
        this.score2 = score2;
    }

    @Generated
    public void setScore3(String score3) {
        this.score3 = score3;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$published = this.getPublished();
        Long other$published = other.getPublished();
        if (this$published == null ? other$published != null : !((Object)this$published).equals(other$published)) {
            return false;
        }
        String this$vId = this.getVId();
        String other$vId = other.getVId();
        if (this$vId == null ? other$vId != null : !this$vId.equals(other$vId)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List this$references = this.getReferences();
        List other$references = other.getReferences();
        if (this$references == null ? other$references != null : !((Object)this$references).equals(other$references)) {
            return false;
        }
        List this$cwes = this.getCwes();
        List other$cwes = other.getCwes();
        if (this$cwes == null ? other$cwes != null : !((Object)this$cwes).equals(other$cwes)) {
            return false;
        }
        String this$cvss2 = this.getCvss2();
        String other$cvss2 = other.getCvss2();
        if (this$cvss2 == null ? other$cvss2 != null : !this$cvss2.equals(other$cvss2)) {
            return false;
        }
        String this$cvss3 = this.getCvss3();
        String other$cvss3 = other.getCvss3();
        if (this$cvss3 == null ? other$cvss3 != null : !this$cvss3.equals(other$cvss3)) {
            return false;
        }
        String this$score2 = this.getScore2();
        String other$score2 = other.getScore2();
        if (this$score2 == null ? other$score2 != null : !this$score2.equals(other$score2)) {
            return false;
        }
        String this$score3 = this.getScore3();
        String other$score3 = other.getScore3();
        return !(this$score3 == null ? other$score3 != null : !this$score3.equals(other$score3));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Vulnerability;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $published = this.getPublished();
        result = result * 59 + ($published == null ? 43 : ((Object)$published).hashCode());
        String $vId = this.getVId();
        result = result * 59 + ($vId == null ? 43 : $vId.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        List $cwes = this.getCwes();
        result = result * 59 + ($cwes == null ? 43 : ((Object)$cwes).hashCode());
        String $cvss2 = this.getCvss2();
        result = result * 59 + ($cvss2 == null ? 43 : $cvss2.hashCode());
        String $cvss3 = this.getCvss3();
        result = result * 59 + ($cvss3 == null ? 43 : $cvss3.hashCode());
        String $score2 = this.getScore2();
        result = result * 59 + ($score2 == null ? 43 : $score2.hashCode());
        String $score3 = this.getScore3();
        result = result * 59 + ($score3 == null ? 43 : $score3.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Vulnerability(vId=" + this.getVId() + ", severity=" + this.getSeverity() + ", description=" + this.getDescription() + ", published=" + this.getPublished() + ", references=" + String.valueOf(this.getReferences()) + ", cwes=" + String.valueOf(this.getCwes()) + ", cvss2=" + this.getCvss2() + ", cvss3=" + this.getCvss3() + ", score2=" + this.getScore2() + ", score3=" + this.getScore3() + ")";
    }
}

