/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.structure;

import com.castsoftware.sca.scar.server.analyzer.structure.FileNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;

public class FileNode {
    private final UUID uuid = UUID.randomUUID();
    private String name;
    private FileNode parent;
    private List<FileNode> children = new ArrayList();
    private FileNodeType type;

    public FileNode() {
    }

    public FileNode(String name, FileNodeType type, FileNode parent) {
        this();
        this.name = name;
        this.type = type;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(FileNode child) {
        this.getChildren().add(child);
    }

    public boolean isFile() {
        return this.getType().equals((Object)FileNodeType.FILE);
    }

    public String getPath() {
        return (this.getParent() != null ? this.getParent().getPath() : "") + this.getName() + (this.getType().equals((Object)FileNodeType.FOLDER) ? "/" : "");
    }

    public Stream<FileNode> stream() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(FileNode::stream));
    }

    public FileNode findOrCreate(String path) {
        return this.findOrCreate(path.split("[/\\\\]", -1));
    }

    private FileNode findOrCreate(String[] pathElements) {
        if (pathElements.length == 1) {
            if (pathElements[0].isEmpty()) {
                return this;
            }
            return this.getChildren().stream().filter(f -> f.getType().equals((Object)FileNodeType.FILE)).filter(f -> f.getName().equals(pathElements[0])).findFirst().orElseGet(() -> new FileNode(pathElements[0], FileNodeType.FILE, this));
        }
        String[] nextElements = Arrays.copyOfRange(pathElements, 1, pathElements.length);
        if (pathElements[0].isEmpty()) {
            return this.findOrCreate(nextElements);
        }
        return this.getChildren().stream().filter(f -> f.getType().equals((Object)FileNodeType.FOLDER)).filter(f -> f.getName().equals(pathElements[0])).findFirst().orElseGet(() -> new FileNode(pathElements[0], FileNodeType.FOLDER, this)).findOrCreate(nextElements);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public FileNode getParent() {
        return this.parent;
    }

    @Generated
    public List<FileNode> getChildren() {
        return this.children;
    }

    @Generated
    public FileNodeType getType() {
        return this.type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setParent(FileNode parent) {
        this.parent = parent;
    }

    @Generated
    public void setChildren(List<FileNode> children) {
        this.children = children;
    }

    @Generated
    public void setType(FileNodeType type) {
        this.type = type;
    }
}

