/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.structure;

import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Category;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.analyzer.structure.License;
import com.castsoftware.sca.scar.server.analyzer.structure.Snippet;
import com.castsoftware.sca.scar.server.analyzer.structure.Vulnerability;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class Component {
    private String scaId;
    private String name;
    private String path;
    private BomSource source;
    private List<FileElement> files = new ArrayList();
    private List<Snippet> snippets = new ArrayList();
    private String version;
    private Set<License> licenses = new HashSet();
    private Set<Vulnerability> vulnerabilities = new HashSet();
    private List<String> references = new ArrayList();
    private Category category;
    private String latestVersion;
    private String description;
    private String repositoryType;
    private String repository;
    private List<String> topics = new ArrayList();
    private List<String> languages = new ArrayList();
    private Map<String, Long> allVersions = new LinkedHashMap();
    private String comments;
    private String upToDate;
    private String linkedComponentId;
    private String copyrights;

    public Component setFiles(List<FileElement> files) {
        this.files = files;
        files.forEach(f -> f.setComponent(this));
        return this;
    }

    public Component addFile(FileElement fileNode) {
        this.getFiles().add(fileNode);
        fileNode.setComponent(this);
        return this;
    }

    public Component setSnippets(List<Snippet> snippets) {
        this.snippets = snippets;
        snippets.forEach(s -> s.setComponent(this));
        return this;
    }

    public Component addSnippet(Snippet snippet) {
        this.getSnippets().add(snippet);
        snippet.setComponent(this);
        return this;
    }

    public Component addLicense(License license) {
        this.getLicenses().add(license);
        return this;
    }

    public Component addVulnerability(Vulnerability vulnerability) {
        this.getVulnerabilities().add(vulnerability);
        return this;
    }

    public Component addReference(String reference) {
        this.getReferences().add(reference);
        return this;
    }

    public Component addTopic(String topic) {
        this.getTopics().add(topic);
        return this;
    }

    public Component addLanguage(String language) {
        this.getLanguages().add(language);
        return this;
    }

    public void addToAllVersions(String version, Long release) {
        this.getAllVersions().put(version, release);
    }

    public void removeFile(FileElement fileNode) {
        this.getFiles().remove(fileNode);
    }

    public void removeSnippet(Snippet snippet) {
        this.getSnippets().remove(snippet);
    }

    public void move(Category category) {
        this.getCategory().remove(this);
        this.setCategory(category);
        category.addComponent(this);
    }

    public boolean isEmpty() {
        return this.getFiles().isEmpty() && this.getSnippets().isEmpty();
    }

    @Generated
    public String getScaId() {
        return this.scaId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public BomSource getSource() {
        return this.source;
    }

    @Generated
    public List<FileElement> getFiles() {
        return this.files;
    }

    @Generated
    public List<Snippet> getSnippets() {
        return this.snippets;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Set<License> getLicenses() {
        return this.licenses;
    }

    @Generated
    public Set<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @Generated
    public List<String> getReferences() {
        return this.references;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getRepositoryType() {
        return this.repositoryType;
    }

    @Generated
    public String getRepository() {
        return this.repository;
    }

    @Generated
    public List<String> getTopics() {
        return this.topics;
    }

    @Generated
    public List<String> getLanguages() {
        return this.languages;
    }

    @Generated
    public Map<String, Long> getAllVersions() {
        return this.allVersions;
    }

    @Generated
    public String getComments() {
        return this.comments;
    }

    @Generated
    public String getUpToDate() {
        return this.upToDate;
    }

    @Generated
    public String getLinkedComponentId() {
        return this.linkedComponentId;
    }

    @Generated
    public String getCopyrights() {
        return this.copyrights;
    }

    @Generated
    public void setScaId(String scaId) {
        this.scaId = scaId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setSource(BomSource source) {
        this.source = source;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setLicenses(Set<License> licenses) {
        this.licenses = licenses;
    }

    @Generated
    public void setVulnerabilities(Set<Vulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    @Generated
    public void setReferences(List<String> references) {
        this.references = references;
    }

    @Generated
    public void setCategory(Category category) {
        this.category = category;
    }

    @Generated
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    @Generated
    public void setRepository(String repository) {
        this.repository = repository;
    }

    @Generated
    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    @Generated
    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    @Generated
    public void setAllVersions(Map<String, Long> allVersions) {
        this.allVersions = allVersions;
    }

    @Generated
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Generated
    public void setUpToDate(String upToDate) {
        this.upToDate = upToDate;
    }

    @Generated
    public void setLinkedComponentId(String linkedComponentId) {
        this.linkedComponentId = linkedComponentId;
    }

    @Generated
    public void setCopyrights(String copyrights) {
        this.copyrights = copyrights;
    }
}

