/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.analyzer.structure;

import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Category {
    private DefaultCategory type;
    private List<Component> components = new ArrayList();

    public Category() {
    }

    public Category(DefaultCategory type) {
        this();
        this.type = type;
    }

    public Category setComponents(@NonNull List<Component> components) {
        this.components = components;
        this.components.forEach(c -> c.setCategory(this));
        return this;
    }

    public Component getComponent(String name, BomSource from) {
        return this.getComponents().stream().filter(c -> name.equals(c.getName())).filter(c -> from == null || from.equals((Object)c.getSource())).findAny().orElse(null);
    }

    public Component getComponentWithVersion(String name, String version, BomSource from) {
        return this.getComponents().stream().filter(c -> name.equals(c.getName())).filter(c -> version == null || version.isEmpty() || c.getVersion().equals(version)).filter(c -> from == null || from.equals((Object)c.getSource())).findAny().orElse(null);
    }

    public Category addComponent(Component component) {
        component.setCategory(this);
        this.getComponents().add(component);
        return this;
    }

    public void clean() {
        this.getComponents().removeIf(Component::isEmpty);
    }

    public void remove(Component component) {
        this.getComponents().remove(component);
    }

    public Component getOrCreateComponent(String name, String scaId, BomSource from, boolean override) {
        Component result = this.getComponent(name, from);
        if (result == null || override && !result.getSource().equals((Object)BomSource.SCA)) {
            result = new Component();
            result.setName(name);
            result.setScaId(scaId);
            this.addComponent(result);
        }
        return result;
    }

    public Component getOrCreateComponentWithVersion(String name, String version, BomSource from, boolean override) {
        Component result = this.getComponentWithVersion(name, version, from);
        if (result == null || override && !result.getSource().equals((Object)BomSource.SCA)) {
            result = new Component();
            result.setName(name);
            this.addComponent(result);
        }
        return result;
    }

    @Generated
    public DefaultCategory getType() {
        return this.type;
    }

    @Generated
    public List<Component> getComponents() {
        return this.components;
    }

    @Generated
    public void setType(DefaultCategory type) {
        this.type = type;
    }
}

